/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.directory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.dubbo.common.Node;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.LockUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.SingleRouterChain;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.support.ClusterUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractDirectory<T>
implements Directory<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractDirectory.class);
    private final URL url;
    private volatile boolean destroyed = false;
    protected volatile URL consumerUrl;
    protected RouterChain<T> routerChain;
    protected final Map<String, String> queryMap;
    private volatile boolean invokersInitialized = false;
    private volatile BitList<Invoker<T>> invokers = BitList.emptyList();
    private volatile BitList<Invoker<T>> validInvokers = BitList.emptyList();
    protected volatile List<Invoker<T>> invokersToReconnect = new CopyOnWriteArrayList<Invoker<T>>();
    protected final Set<Invoker<T>> disabledInvokers = new ConcurrentHashSet<Invoker<T>>();
    private final Semaphore checkConnectivityPermit = new Semaphore(1);
    private final ScheduledExecutorService connectivityExecutor;
    private volatile ScheduledFuture<?> connectivityCheckFuture;
    private final ReentrantLock invokerRefreshLock = new ReentrantLock();
    private final int reconnectTaskTryCount;
    private final int reconnectTaskPeriod;
    private ApplicationModel applicationModel;

    public AbstractDirectory(URL url) {
        this(url, null, false);
    }

    public AbstractDirectory(URL url, boolean isUrlFromRegistry) {
        this(url, null, isUrlFromRegistry);
    }

    public AbstractDirectory(URL url, RouterChain<T> routerChain, boolean isUrlFromRegistry) {
        Map<String, String> queryMap;
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.url = url.removeAttribute("refer").removeAttribute("monitor");
        Object referParams = url.getAttribute("refer");
        if (referParams instanceof Map) {
            queryMap = (Map<String, String>)referParams;
            this.consumerUrl = (URL)url.getAttribute("CONSUMER_URL");
        } else {
            queryMap = StringUtils.parseQueryString(url.getParameterAndDecoded("refer"));
        }
        this.applicationModel = url.getOrDefaultApplicationModel();
        this.queryMap = this.applicationModel.getBeanFactory().getBean(ClusterUtils.class).mergeLocalParams(queryMap);
        if (this.consumerUrl == null) {
            String host = StringUtils.isNotEmpty(queryMap.get("register.ip")) ? queryMap.get("register.ip") : this.url.getHost();
            String path = StringUtils.isNotEmpty(queryMap.get("path")) ? queryMap.get("path") : queryMap.get("interface");
            String consumedProtocol = StringUtils.isNotEmpty(queryMap.get("protocol")) ? queryMap.get("protocol") : "consumer";
            URL consumerUrlFrom = this.url.setHost(host).setPort(0).setProtocol(consumedProtocol).setPath(path);
            if (isUrlFromRegistry) {
                consumerUrlFrom = consumerUrlFrom.clearParameters();
            }
            this.consumerUrl = consumerUrlFrom.addParameters(queryMap);
        }
        this.connectivityExecutor = this.applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class).getConnectivityScheduledExecutor();
        Configuration configuration = ConfigurationUtils.getGlobalConfiguration(url.getOrDefaultModuleModel());
        this.reconnectTaskTryCount = configuration.getInt("dubbo.reconnect.reconnectTaskTryCount", 10);
        this.reconnectTaskPeriod = configuration.getInt("dubbo.reconnect.reconnectTaskPeriod", 1000);
        this.setRouterChain(routerChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Invoker<T>> list(Invocation invocation) throws RpcException {
        if (this.destroyed) {
            throw new RpcException("Directory of type " + this.getClass().getSimpleName() + " already destroyed for service " + this.getConsumerUrl().getServiceKey() + " from registry " + this.getUrl());
        }
        SingleRouterChain<T> singleChain = null;
        try {
            Object availableInvokers;
            try {
                if (this.routerChain != null) {
                    this.routerChain.getLock().readLock().lock();
                }
                availableInvokers = this.invokersInitialized ? this.validInvokers.clone() : this.invokers.clone();
                if (this.routerChain != null) {
                    singleChain = this.routerChain.getSingleChain(this.getConsumerUrl(), (BitList<Invoker<T>>)availableInvokers, invocation);
                    singleChain.getLock().readLock().lock();
                }
            }
            finally {
                if (this.routerChain != null) {
                    this.routerChain.getLock().readLock().unlock();
                }
            }
            List<Invoker<T>> routedResult = this.doList(singleChain, (BitList<Invoker<T>>)availableInvokers, invocation);
            if (routedResult.isEmpty()) {
                logger.warn("2-2", "provider server or registry center crashed", "", "No provider available after connectivity filter for the service " + this.getConsumerUrl().getServiceKey() + " All routed invokers' size: " + routedResult.size() + " from registry " + this + " on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + ".");
            }
            List<Invoker<T>> list = Collections.unmodifiableList(routedResult);
            return list;
        }
        finally {
            if (singleChain != null) {
                singleChain.getLock().readLock().unlock();
            }
        }
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public RouterChain<T> getRouterChain() {
        return this.routerChain;
    }

    public void setRouterChain(RouterChain<T> routerChain) {
        this.routerChain = routerChain;
    }

    protected void addRouters(List<Router> routers) {
        routers = routers == null ? Collections.emptyList() : routers;
        this.routerChain.addRouters(routers);
    }

    @Override
    public URL getConsumerUrl() {
        return this.consumerUrl;
    }

    public void setConsumerUrl(URL consumerUrl) {
        this.consumerUrl = consumerUrl;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.destroyInvokers();
        this.invokersToReconnect.clear();
        this.disabledInvokers.clear();
    }

    @Override
    public void discordAddresses() {
    }

    @Override
    public void addInvalidateInvoker(Invoker<T> invoker) {
        LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> {
            if (this.removeValidInvoker(invoker)) {
                this.invokersToReconnect.add(invoker);
                this.checkConnectivity();
                logger.info("The invoker " + invoker.getUrl() + " has been added to invalidate list due to connectivity problem. Will trying to reconnect to it in the background.");
            }
        });
    }

    public void checkConnectivity() {
        if (this.checkConnectivityPermit.tryAcquire()) {
            this.connectivityCheckFuture = this.connectivityExecutor.schedule(() -> {
                try {
                    if (this.isDestroyed()) {
                        return;
                    }
                    RpcContext.getServiceContext().setConsumerUrl(this.getConsumerUrl());
                    ArrayList<Invoker> needDeleteList = new ArrayList<Invoker>();
                    ArrayList invokersToTry = new ArrayList();
                    LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> {
                        if (this.invokersToReconnect.size() < this.reconnectTaskTryCount) {
                            invokersToTry.addAll(this.invokersToReconnect);
                        } else {
                            for (int i = 0; i < this.reconnectTaskTryCount; ++i) {
                                Invoker<T> tInvoker = this.invokersToReconnect.get(ThreadLocalRandom.current().nextInt(this.invokersToReconnect.size()));
                                if (invokersToTry.contains(tInvoker)) continue;
                                invokersToTry.add(tInvoker);
                            }
                        }
                    });
                    for (Invoker invoker : invokersToTry) {
                        AtomicBoolean invokerExist = new AtomicBoolean(false);
                        LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> invokerExist.set(this.invokers.contains(invoker)));
                        if (invokerExist.get()) {
                            if (!invoker.isAvailable()) continue;
                            needDeleteList.add(invoker);
                            continue;
                        }
                        needDeleteList.add(invoker);
                    }
                    LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> {
                        for (Invoker tInvoker : needDeleteList) {
                            if (this.invokers.contains(tInvoker)) {
                                this.addValidInvoker(tInvoker);
                                logger.info("Recover service address: " + tInvoker.getUrl() + "  from invalid list.");
                            } else {
                                logger.info("The invoker " + tInvoker.getUrl() + " has been removed from invokers list. Will remove it in reconnect list.");
                            }
                            this.invokersToReconnect.remove(tInvoker);
                        }
                    });
                }
                catch (Throwable t) {
                    logger.error("99-0", "", "", "Error occurred when check connectivity. ", t);
                }
                finally {
                    this.checkConnectivityPermit.release();
                }
                LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> {
                    if (!this.invokersToReconnect.isEmpty()) {
                        this.checkConnectivity();
                    }
                });
                MetricsEventBus.publish(RegistryEvent.refreshDirectoryEvent(this.applicationModel, this.getSummary(), this.getDirectoryMeta()));
            }, (long)this.reconnectTaskPeriod, TimeUnit.MILLISECONDS);
        }
        MetricsEventBus.publish(RegistryEvent.refreshDirectoryEvent(this.applicationModel, this.getSummary(), this.getDirectoryMeta()));
    }

    public void refreshInvoker() {
        LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> {
            if (this.invokersInitialized) {
                this.refreshInvokerInternal();
            }
        });
        MetricsEventBus.publish(RegistryEvent.refreshDirectoryEvent(this.applicationModel, this.getSummary(), this.getDirectoryMeta()));
    }

    protected Map<String, String> getDirectoryMeta() {
        return Collections.emptyMap();
    }

    private void refreshInvokerInternal() {
        Object copiedInvokers = this.invokers.clone();
        this.refreshInvokers((BitList<Invoker<T>>)copiedInvokers, (Collection<Invoker<T>>)this.invokersToReconnect);
        this.refreshInvokers((BitList<Invoker<T>>)copiedInvokers, (Collection<Invoker<T>>)this.disabledInvokers);
        this.validInvokers = copiedInvokers;
    }

    private void refreshInvokers(BitList<Invoker<T>> targetInvokers, Collection<Invoker<T>> invokersToRemove) {
        LinkedList<Invoker<T>> needToRemove = new LinkedList<Invoker<T>>();
        for (Invoker<T> tInvoker : invokersToRemove) {
            if (targetInvokers.contains(tInvoker)) {
                targetInvokers.remove(tInvoker);
                continue;
            }
            needToRemove.add(tInvoker);
        }
        invokersToRemove.removeAll(needToRemove);
    }

    @Override
    public void addDisabledInvoker(Invoker<T> invoker) {
        LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> {
            if (this.invokers.contains(invoker)) {
                this.disabledInvokers.add(invoker);
                this.removeValidInvoker(invoker);
                logger.info("Disable service address: " + invoker.getUrl() + ".");
            }
        });
        MetricsEventBus.publish(RegistryEvent.refreshDirectoryEvent(this.applicationModel, this.getSummary(), this.getDirectoryMeta()));
    }

    @Override
    public void recoverDisabledInvoker(Invoker<T> invoker) {
        LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> {
            if (this.disabledInvokers.remove(invoker)) {
                try {
                    this.addValidInvoker(invoker);
                    logger.info("Recover service address: " + invoker.getUrl() + "  from disabled list.");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        MetricsEventBus.publish(RegistryEvent.refreshDirectoryEvent(this.applicationModel, this.getSummary(), this.getDirectoryMeta()));
    }

    protected final void refreshRouter(BitList<Invoker<T>> newlyInvokers, Runnable switchAction) {
        try {
            this.routerChain.setInvokers((BitList<Invoker<T>>)newlyInvokers.clone(), switchAction);
        }
        catch (Throwable t) {
            logger.error("99-0", "", "", "Error occurred when refreshing router chain. The addresses from notification: " + newlyInvokers.stream().map(Node::getUrl).map(URL::getAddress).collect(Collectors.joining(", ")), t);
            throw t;
        }
    }

    @Deprecated
    public Semaphore getCheckConnectivityPermit() {
        return this.checkConnectivityPermit;
    }

    @Deprecated
    public ScheduledFuture<?> getConnectivityCheckFuture() {
        return this.connectivityCheckFuture;
    }

    public BitList<Invoker<T>> getInvokers() {
        return this.invokers.clone();
    }

    public BitList<Invoker<T>> getValidInvokers() {
        return this.validInvokers.clone();
    }

    public List<Invoker<T>> getInvokersToReconnect() {
        return this.invokersToReconnect;
    }

    public Set<Invoker<T>> getDisabledInvokers() {
        return this.disabledInvokers;
    }

    protected void setInvokers(BitList<Invoker<T>> invokers) {
        LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> {
            this.invokers = invokers;
            this.refreshInvokerInternal();
            this.invokersInitialized = true;
        });
        MetricsEventBus.publish(RegistryEvent.refreshDirectoryEvent(this.applicationModel, this.getSummary(), this.getDirectoryMeta()));
    }

    protected void destroyInvokers() {
        LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> {
            this.invokers = BitList.emptyList();
            this.validInvokers = BitList.emptyList();
            this.invokersInitialized = false;
        });
    }

    private boolean addValidInvoker(Invoker<T> invoker) {
        AtomicBoolean result = new AtomicBoolean(false);
        LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> result.set(this.validInvokers.add(invoker)));
        MetricsEventBus.publish(RegistryEvent.refreshDirectoryEvent(this.applicationModel, this.getSummary(), this.getDirectoryMeta()));
        return result.get();
    }

    private boolean removeValidInvoker(Invoker<T> invoker) {
        AtomicBoolean result = new AtomicBoolean(false);
        LockUtils.safeLock(this.invokerRefreshLock, 60000, () -> result.set(this.validInvokers.remove(invoker)));
        MetricsEventBus.publish(RegistryEvent.refreshDirectoryEvent(this.applicationModel, this.getSummary(), this.getDirectoryMeta()));
        return result.get();
    }

    protected abstract List<Invoker<T>> doList(SingleRouterChain<T> var1, BitList<Invoker<T>> var2, Invocation var3) throws RpcException;

    protected String joinValidInvokerAddresses() {
        Object validInvokers = this.getValidInvokers().clone();
        if (((BitList)validInvokers).isEmpty()) {
            return "empty";
        }
        return validInvokers.stream().limit(5L).map(Node::getUrl).map(URL::getAddress).collect(Collectors.joining(","));
    }

    private Map<MetricsKey, Map<String, Integer>> getSummary() {
        HashMap<MetricsKey, Map<String, Integer>> summaryMap = new HashMap<MetricsKey, Map<String, Integer>>();
        summaryMap.put(MetricsKey.DIRECTORY_METRIC_NUM_VALID, this.groupByServiceKey(this.getValidInvokers()));
        summaryMap.put(MetricsKey.DIRECTORY_METRIC_NUM_DISABLE, this.groupByServiceKey(this.getDisabledInvokers()));
        summaryMap.put(MetricsKey.DIRECTORY_METRIC_NUM_TO_RECONNECT, this.groupByServiceKey(this.getInvokersToReconnect()));
        summaryMap.put(MetricsKey.DIRECTORY_METRIC_NUM_ALL, this.groupByServiceKey(this.getInvokers()));
        return summaryMap;
    }

    private Map<String, Integer> groupByServiceKey(Collection<Invoker<T>> invokers) {
        return Collections.singletonMap(this.getConsumerUrl().getServiceKey(), invokers.size());
    }

    public String toString() {
        return "Directory(invokers: " + this.invokers.size() + "[" + this.invokers.stream().map(Node::getUrl).map(URL::getAddress).limit(3L).collect(Collectors.joining(", ")) + "], validInvokers: " + this.validInvokers.size() + "[" + this.validInvokers.stream().map(Node::getUrl).map(URL::getAddress).limit(3L).collect(Collectors.joining(", ")) + "], invokersToReconnect: " + this.invokersToReconnect.size() + "[" + this.invokersToReconnect.stream().map(Node::getUrl).map(URL::getAddress).limit(3L).collect(Collectors.joining(", ")) + "]" + ')';
    }
}

