/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest.exception.mapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionHandler;
import org.apache.dubbo.rpc.protocol.rest.exception.mapper.ExceptionHandlerResult;
import org.apache.dubbo.rpc.protocol.rest.util.ReflectUtils;

public class ExceptionMapper {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final Map<Class<?>, ExceptionHandler> exceptionHandlerMap = new ConcurrentHashMap();
    private final Map allExceptionHandlers = new ConcurrentHashMap();

    public ExceptionHandlerResult exceptionToResult(Object throwable) {
        ExceptionHandler exceptionHandler = (ExceptionHandler)this.getExceptionHandler(throwable.getClass());
        Object result = exceptionHandler.result((Throwable)throwable);
        return ExceptionHandlerResult.build().setEntity(result).setStatus(exceptionHandler.status());
    }

    public Object getExceptionHandler(Class causeClass) {
        return this.getExceptionHandler(this.allExceptionHandlers, causeClass);
    }

    public Object getExceptionHandler(Map exceptionHandlerMap, Class causeClass) {
        Object exceptionHandler = null;
        while (causeClass != null && (exceptionHandler = exceptionHandlerMap.get(causeClass)) == null) {
            causeClass = causeClass.getSuperclass();
        }
        return exceptionHandler;
    }

    public boolean hasExceptionMapper(Object throwable) {
        if (throwable == null) {
            return false;
        }
        return this.allExceptionHandlers.containsKey(throwable.getClass());
    }

    public void registerMapper(Class<?> exceptionHandler) {
        try {
            List<Constructor<?>> constructors;
            List<Method> methods = this.getExceptionHandlerMethods(exceptionHandler);
            if (methods == null || methods.isEmpty()) {
                return;
            }
            HashSet exceptions = new HashSet();
            for (Method method : methods) {
                Class<?> parameterType = method.getParameterTypes()[0];
                if (!Throwable.class.isAssignableFrom(parameterType)) continue;
                exceptions.add(parameterType);
            }
            ArrayList classes = new ArrayList(exceptions);
            if (classes.size() != 1) {
                exceptions.remove(Throwable.class);
            }
            if ((constructors = ReflectUtils.getConstructList(exceptionHandler)).isEmpty()) {
                throw new RuntimeException("dubbo rest exception mapper register mapper need exception handler exist no  construct declare, current class is: " + exceptionHandler);
            }
            Object handler = constructors.get(0).newInstance(new Object[constructors.get(0).getParameterCount()]);
            this.putExtensionToMap(exceptions, handler);
        }
        catch (Exception e) {
            throw new RuntimeException("dubbo rest protocol exception mapper register error ", e);
        }
    }

    protected void putExtensionToMap(Set<Class<?>> exceptions, Object handler) {
        Map exceptionHandlerMaps = this.getExceptionHandlerMap(handler);
        for (Class<?> exception : exceptions) {
            exceptionHandlerMaps.put(exception, handler);
            this.allExceptionHandlers.put(exception, handler);
        }
    }

    protected Map getExceptionHandlerMap(Object handler) {
        return this.exceptionHandlerMap;
    }

    protected List<Method> getExceptionHandlerMethods(Class<?> exceptionHandler) {
        if (!ExceptionHandler.class.isAssignableFrom(exceptionHandler)) {
            return null;
        }
        List<Method> methods = ReflectUtils.getMethodByNameList(exceptionHandler, "result");
        return methods;
    }

    public void registerMapper(String exceptionMapper) {
        try {
            this.registerMapper(ReflectUtils.findClass(exceptionMapper));
        }
        catch (Exception e) {
            this.logger.warn("", e.getMessage(), "", "dubbo rest protocol exception mapper register error ,and current exception mapper is  :" + exceptionMapper);
        }
    }

    public void unRegisterMapper(Class<?> exception) {
        this.exceptionHandlerMap.remove(exception);
    }

    public static boolean isSupport(Class<?> exceptionHandler) {
        try {
            return ExceptionHandler.class.isAssignableFrom(exceptionHandler) || ReflectUtils.findClassTryException("javax.ws.rs.ext.ExceptionMapper").isAssignableFrom(exceptionHandler);
        }
        catch (Exception e) {
            return false;
        }
    }
}

