/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.security.cert;

import java.util.Objects;
import org.apache.dubbo.common.deploy.ApplicationDeployListener;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.security.cert.CertConfig;
import org.apache.dubbo.security.cert.DubboCertManager;

public class CertDeployerListener
implements ApplicationDeployListener {
    private final DubboCertManager dubboCertManager;

    public CertDeployerListener(FrameworkModel frameworkModel) {
        this.dubboCertManager = frameworkModel.getBeanFactory().getBean(DubboCertManager.class);
    }

    @Override
    public void onInitialize(ApplicationModel scopeModel) {
    }

    @Override
    public void onStarting(ApplicationModel scopeModel) {
        scopeModel.getApplicationConfigManager().getSsl().ifPresent(sslConfig -> {
            if (Objects.nonNull(sslConfig.getCaAddress()) && this.dubboCertManager != null) {
                CertConfig certConfig = new CertConfig(sslConfig.getCaAddress(), sslConfig.getEnvType(), sslConfig.getCaCertPath(), sslConfig.getOidcTokenPath());
                this.dubboCertManager.connect(certConfig);
            }
        });
    }

    @Override
    public void onStarted(ApplicationModel scopeModel) {
    }

    @Override
    public void onStopping(ApplicationModel scopeModel) {
        if (this.dubboCertManager != null) {
            this.dubboCertManager.disConnect();
        }
    }

    @Override
    public void onStopped(ApplicationModel scopeModel) {
    }

    @Override
    public void onFailure(ApplicationModel scopeModel, Throwable cause) {
        if (this.dubboCertManager != null) {
            this.dubboCertManager.disConnect();
        }
    }
}

