/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.http;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdleConnectionReaper
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleConnectionReaper.class);
    private static final int REAP_INTERVAL_MILLISECONDS = 5000;
    private static final ArrayList<HttpClientConnectionManager> connectionManagers = new ArrayList();
    private static IdleConnectionReaper instance;
    private static long idleConnectionTime;
    private volatile boolean shuttingDown = false;

    private IdleConnectionReaper() {
        super("idle_connection_reaper");
        this.setDaemon(true);
    }

    public static synchronized void registerConnectionManager(HttpClientConnectionManager connectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
            instance.start();
        }
        connectionManagers.add(connectionManager);
    }

    public static synchronized void removeConnectionManager(HttpClientConnectionManager connectionManager) {
        connectionManagers.remove(connectionManager);
        if (connectionManagers.isEmpty()) {
            IdleConnectionReaper.shutdown();
        }
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block4: while (!this.shuttingDown) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("connection error..." + e);
            }
            Object object = IdleConnectionReaper.class;
            // MONITORENTER : com.huaweicloud.lts.producer.http.IdleConnectionReaper.class
            List connectionManagers = (List)IdleConnectionReaper.connectionManagers.clone();
            // MONITOREXIT : object
            object = connectionManagers.iterator();
            while (true) {
                if (!object.hasNext()) continue block4;
                HttpClientConnectionManager connectionManager = (HttpClientConnectionManager)object.next();
                connectionManager.closeExpiredConnections();
                connectionManager.closeIdleConnections(idleConnectionTime, TimeUnit.MILLISECONDS);
            }
            break;
        }
        return;
    }

    public static synchronized void shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
        }
    }

    public static synchronized void setIdleConnectionTime(long idletime) {
        idleConnectionTime = idletime;
    }

    static {
        idleConnectionTime = 60000L;
    }
}

