/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common.utils;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.http.HttpHeaders;

public class LogCollectUtils {
    private static final Set<String> BINARY_TYPE_LIST = Sets.newHashSet((Object[])new String[]{"image", "multipart", "cbor", "octet-stream", "pdf", "javascript", "css", "html"});

    public static boolean isNotBinaryType(HttpHeaders headers) {
        return Optional.ofNullable(headers).map(HttpHeaders::getContentType).map(contentType -> !BINARY_TYPE_LIST.contains(contentType.getType()) && !BINARY_TYPE_LIST.contains(contentType.getSubtype())).orElse(true);
    }

    public static String getHeaders(HttpHeaders headers) {
        Map<String, String> map = headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.join((CharSequence)",", (Iterable)entry.getValue())));
        return JsonUtils.toJson(map);
    }
}

