/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.Serializer;
import io.fury.util.Preconditions;
import io.fury.util.ReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class JdkProxySerializer
extends Serializer {
    public JdkProxySerializer(Fury fury, Class cls) {
        super(fury, cls);
        if (cls != ReplaceStub.class) {
            Preconditions.checkArgument(ReflectionUtils.isJdkProxy(cls), "Require a jdk proxy class");
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
        this.fury.writeRef(buffer, Proxy.getInvocationHandler(value));
        this.fury.writeRef(buffer, value.getClass().getInterfaces());
    }

    public Object read(MemoryBuffer buffer) {
        InvocationHandler invocationHandler = (InvocationHandler)this.fury.readRef(buffer);
        Preconditions.checkNotNull(invocationHandler);
        Class[] interfaces = (Class[])this.fury.readRef(buffer);
        Preconditions.checkNotNull(interfaces);
        return Proxy.newProxyInstance(this.fury.getClassLoader(), interfaces, invocationHandler);
    }

    public static class ReplaceStub {
    }
}

