/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.internal.shared;

import java.awt.Dimension;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Arrays;
import org.apache.sis.image.DataType;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;

public final class SampleModelBuilder {
    private int dataType;
    private final int width;
    private final int height;
    private int numBands;
    private int[] bankIndices;
    private int[] bandOffsets;
    private int[] bitMasks;
    private int dataBitOffset;
    private int numberOfBits;
    private int pixelStride;
    private int scanlineStride;

    /*
     * Enabled aggressive block sorting
     */
    public SampleModelBuilder(DataType type, Dimension size, int[] bitsPerSample, boolean isBanded) {
        this.dataType = type.toDataBufferType();
        this.width = size.width;
        this.height = size.height;
        this.numBands = bitsPerSample.length;
        this.scanlineStride = this.width;
        this.pixelStride = 1;
        boolean packed = true;
        int elementSize = type.size();
        for (int n : bitsPerSample) {
            if (n < elementSize) continue;
            packed = false;
            break;
        }
        if (packed) {
            if (this.numBands == 1) {
                this.pixelStride = 0;
                this.numberOfBits = bitsPerSample[0];
                this.scanlineStride = JDK18.ceilDiv((int)Math.multiplyExact(this.width, this.numberOfBits), (int)elementSize);
                return;
            }
            if (isBanded) throw new RasterFormatException(Errors.format((short)200, (Object)("bitsPerSample=" + bitsPerSample[0])));
            int shift = 0;
            this.bitMasks = new int[this.numBands];
            int i = 0;
            while (true) {
                if (i >= this.numBands) {
                    if (shift <= elementSize) return;
                    throw new RasterFormatException(Errors.format((short)91, (Object)elementSize));
                }
                int n = bitsPerSample[i];
                ArgumentChecks.ensureBetween((String)"bitsPerSample", (int)1, (int)elementSize, (int)n);
                this.bitMasks[i] = (1 << n) - 1 << shift;
                shift += n;
                ++i;
            }
        }
        if (isBanded) {
            this.bankIndices = ArraysExt.range((int)0, (int)this.numBands);
            this.bandOffsets = new int[this.numBands];
            return;
        }
        this.bandOffsets = ArraysExt.range((int)0, (int)this.numBands);
        this.scanlineStride = Math.multiplyExact(this.numBands, this.width);
        this.pixelStride = this.numBands;
    }

    public SampleModelBuilder(SampleModel model) {
        this.width = model.getWidth();
        this.height = model.getHeight();
        this.numBands = model.getNumBands();
        this.dataType = model.getDataType();
        if (model instanceof ComponentSampleModel) {
            ComponentSampleModel cm = (ComponentSampleModel)model;
            this.bankIndices = cm.getBankIndices();
            this.bandOffsets = cm.getBandOffsets();
            this.scanlineStride = cm.getScanlineStride();
            this.pixelStride = cm.getPixelStride();
            for (int i = 0; i < this.bankIndices.length; ++i) {
                if (this.bankIndices[i] == 0) continue;
                return;
            }
            this.bankIndices = null;
        } else if (model instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel cm = (SinglePixelPackedSampleModel)model;
            this.bitMasks = cm.getBitMasks();
            this.scanlineStride = cm.getScanlineStride();
            this.pixelStride = 1;
        } else if (model instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel cm = (MultiPixelPackedSampleModel)model;
            this.numberOfBits = cm.getPixelBitStride();
            this.dataBitOffset = cm.getDataBitOffset();
            this.scanlineStride = cm.getScanlineStride();
        } else {
            throw new RasterFormatException(Errors.format((short)200, model.getClass()));
        }
    }

    public void subsetAndCompress(int[] bands) {
        ArgumentChecks.ensureCountBetween((String)"bands", (boolean)true, (int)1, (int)this.numBands, (int)bands.length);
        if (this.bankIndices != null) {
            this.bankIndices = SampleModelBuilder.subset(this.bankIndices, bands, true);
        }
        if (this.bandOffsets != null) {
            this.bandOffsets = SampleModelBuilder.subset(this.bandOffsets, bands, this.bankIndices == null);
        }
        if (this.bitMasks != null) {
            int i;
            int[] shifts = new int[this.bitMasks.length];
            for (i = 0; i < shifts.length; ++i) {
                shifts[i] = SampleModelBuilder.bitCount(this.bitMasks[i]);
            }
            for (i = 0; i < bands.length; ++i) {
                shifts[bands[i]] = 0;
            }
            for (i = 1; i < shifts.length; ++i) {
                int n = i;
                shifts[n] = shifts[n] + shifts[i - 1];
            }
            int[] masks = new int[bands.length];
            int allMasks = 0;
            for (int i2 = 0; i2 < bands.length; ++i2) {
                int b = bands[i2];
                masks[i2] = this.bitMasks[b] >>> shifts[b];
                allMasks |= masks[i2];
            }
            this.bitMasks = masks;
            if (this.dataType == 3 && (allMasks & 0xFFFF0000) == 0) {
                this.dataType = 1;
            }
            if (this.dataType == 1 && (allMasks & 0xFFFFFF00) == 0) {
                this.dataType = 0;
            }
        }
        if (this.pixelStride > 1) {
            int s = this.scanlineStride / this.pixelStride;
            int r = this.scanlineStride % this.pixelStride;
            this.pixelStride -= this.numBands - bands.length;
            this.scanlineStride = this.pixelStride * s + r;
        }
        this.numBands = bands.length;
    }

    private static int bitCount(int mask) {
        return 32 - Integer.numberOfLeadingZeros(mask) - Integer.numberOfTrailingZeros(mask);
    }

    private static int[] subset(int[] data, int[] bands, boolean compress) {
        int[] subset = new int[bands.length];
        for (int i = 0; i < bands.length; ++i) {
            subset[i] = data[bands[i]];
        }
        if (!compress) {
            return subset;
        }
        Arrays.sort(subset);
        int[] indices = new int[subset.length];
        for (int i = 0; i < bands.length; ++i) {
            indices[i] = Arrays.binarySearch(subset, data[bands[i]]);
            assert (indices[i] >= 0);
        }
        return indices;
    }

    public boolean unpack(boolean banded) {
        if (this.bitMasks != null) {
            int max = 0;
            for (int i = 0; i < this.numBands; ++i) {
                int mask = this.bitMasks[i];
                if ((mask >>>= Integer.numberOfTrailingZeros(mask)) <= max) continue;
                max = mask;
            }
            this.numberOfBits = 32 - Integer.numberOfLeadingZeros(max);
            this.bitMasks = null;
        } else if (this.numberOfBits == 0) {
            return false;
        }
        if (this.numberOfBits <= 8) {
            this.dataType = 0;
        } else if (this.numberOfBits > 16) {
            this.dataType = 3;
        } else if (this.dataType > 2) {
            this.dataType = 1;
        }
        this.numberOfBits = 0;
        this.pixelStride = this.numBands;
        this.scanlineStride = Math.multiplyExact(this.width, this.numBands);
        this.bandOffsets = ArraysExt.range((int)0, (int)this.numBands);
        this.bankIndices = null;
        if (banded) {
            this.pixelStride = 1;
            this.scanlineStride = this.width;
            this.bankIndices = this.bandOffsets;
            this.bandOffsets = new int[this.numBands];
        }
        return true;
    }

    public SampleModel build() {
        if (this.pixelStride == 1) {
            if (this.bankIndices != null) {
                return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, this.bankIndices, this.bandOffsets);
            }
            if (this.bitMasks != null) {
                return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, this.bitMasks);
            }
        }
        if (this.numberOfBits != 0) {
            return new MultiPixelPackedSampleModel(this.dataType, this.width, this.height, this.numberOfBits, this.scanlineStride, this.dataBitOffset);
        }
        return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, this.bandOffsets);
    }
}

