/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.oap.query.graphql.AsyncQueryUtils;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.query.LogQueryService;
import org.apache.skywalking.oap.server.core.query.TagAutoCompleteQueryService;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.LogQueryCondition;
import org.apache.skywalking.oap.server.core.query.input.LogQueryConditionByName;
import org.apache.skywalking.oap.server.core.query.type.Logs;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class LogQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private LogQueryService logQueryService;
    private TagAutoCompleteQueryService tagQueryService;

    public LogQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private LogQueryService getQueryService() {
        if (this.logQueryService == null) {
            this.logQueryService = (LogQueryService)this.moduleManager.find("core").provider().getService(LogQueryService.class);
        }
        return this.logQueryService;
    }

    private TagAutoCompleteQueryService getTagQueryService() {
        if (this.tagQueryService == null) {
            this.tagQueryService = (TagAutoCompleteQueryService)this.moduleManager.find("core").provider().getService(TagAutoCompleteQueryService.class);
        }
        return this.tagQueryService;
    }

    public boolean supportQueryLogsByKeywords() {
        return this.getQueryService().supportQueryLogsByKeywords();
    }

    public CompletableFuture<Logs> queryLogs(LogQueryCondition condition, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("LogQueryCondition: " + String.valueOf(condition), debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query logs");
            try {
                Logs logs = this.invokeQueryLogs(condition);
                if (debug) {
                    logs.setDebuggingTrace(traceContext.getExecTrace());
                }
                Logs logs2 = logs;
                return logs2;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    public CompletableFuture<Logs> queryLogsByName(LogQueryConditionByName condition, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("LogQueryConditionByName: " + String.valueOf(condition), debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query logs");
            try {
                LogQueryCondition logQueryCondition = new LogQueryCondition();
                logQueryCondition.setServiceId(condition.getServiceId());
                logQueryCondition.setServiceInstanceId(condition.getServiceInstanceId());
                logQueryCondition.setEndpointId(condition.getEndpointId());
                logQueryCondition.setRelatedTrace(condition.getRelatedTrace());
                logQueryCondition.setQueryDuration(condition.getQueryDuration());
                logQueryCondition.setPaging(condition.getPaging());
                logQueryCondition.setTags(condition.getTags());
                logQueryCondition.setKeywordsOfContent(condition.getKeywordsOfContent());
                logQueryCondition.setExcludingKeywordsOfContent(condition.getExcludingKeywordsOfContent());
                logQueryCondition.setQueryOrder(condition.getQueryOrder());
                Logs logs = this.invokeQueryLogs(logQueryCondition);
                if (debug) {
                    logs.setDebuggingTrace(traceContext.getExecTrace());
                }
                Logs logs2 = logs;
                return logs2;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    private Logs invokeQueryLogs(LogQueryCondition condition) throws IOException {
        Order queryOrder;
        if (Objects.isNull(condition.getQueryDuration()) && Objects.isNull(condition.getRelatedTrace())) {
            throw new UnexpectedException("The condition must contains either queryDuration or relatedTrace.");
        }
        Order order = queryOrder = Objects.isNull(condition.getQueryOrder()) ? Order.DES : condition.getQueryOrder();
        if (CollectionUtils.isNotEmpty((List)condition.getTags())) {
            condition.getTags().forEach(tag -> {
                if (tag != null) {
                    if (StringUtil.isNotEmpty((String)tag.getKey())) {
                        tag.setKey(tag.getKey().trim());
                    }
                    if (StringUtil.isNotEmpty((String)tag.getValue())) {
                        tag.setValue(tag.getValue().trim());
                    }
                }
            });
        }
        return this.getQueryService().queryLogs(condition.getServiceId(), condition.getServiceInstanceId(), condition.getEndpointId(), condition.getRelatedTrace(), condition.getPaging(), queryOrder, condition.getQueryDuration(), condition.getTags(), condition.getKeywordsOfContent(), condition.getExcludingKeywordsOfContent());
    }

    public CompletableFuture<Set<String>> queryLogTagAutocompleteKeys(Duration queryDuration) {
        return AsyncQueryUtils.queryAsync(() -> this.getTagQueryService().queryTagAutocompleteKeys(TagType.LOG, queryDuration));
    }

    public CompletableFuture<Set<String>> queryLogTagAutocompleteValues(String tagKey, Duration queryDuration) {
        return AsyncQueryUtils.queryAsync(() -> this.getTagQueryService().queryTagAutocompleteValues(TagType.LOG, tagKey, queryDuration));
    }
}

