/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.AbstractEndpointSelector;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.loadbalancer.LoadBalancer;
import com.linecorp.armeria.common.util.ListenableAsyncCloseable;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import java.util.List;

final class DefaultEndpointSelector<T extends LoadBalancer<Endpoint, ClientRequestContext>>
extends AbstractEndpointSelector {
    private final LoadBalancerFactory<T> loadBalancerFactory;
    @Nullable
    private volatile T loadBalancer;
    private boolean closed;
    private final ReentrantShortLock lock = new ReentrantShortLock();

    DefaultEndpointSelector(EndpointGroup endpointGroup, LoadBalancerFactory<T> loadBalancerFactory) {
        super(endpointGroup);
        this.loadBalancerFactory = loadBalancerFactory;
        if (endpointGroup instanceof ListenableAsyncCloseable) {
            ((ListenableAsyncCloseable)((Object)endpointGroup)).whenClosed().thenAccept(unused -> {
                this.lock.lock();
                try {
                    this.closed = true;
                    T loadBalancer = this.loadBalancer;
                    if (loadBalancer != null) {
                        loadBalancer.close();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            });
        }
        this.initialize();
    }

    @Override
    protected void updateNewEndpoints(List<Endpoint> endpoints) {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.loadBalancer = (LoadBalancer)this.loadBalancerFactory.newLoadBalancer(this.loadBalancer, endpoints);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public Endpoint selectNow(ClientRequestContext ctx) {
        T loadBalancer = this.loadBalancer;
        if (loadBalancer == null) {
            return null;
        }
        return (Endpoint)loadBalancer.pick((ClientRequestContext)ctx);
    }

    @FunctionalInterface
    static interface LoadBalancerFactory<T> {
        public T newLoadBalancer(@Nullable T var1, List<Endpoint> var2);

        default public T unsafeCast(LoadBalancer<Endpoint, ?> loadBalancer) {
            return (T)loadBalancer;
        }
    }
}

