/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceElement;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceExtensions;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceFactory;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.AnnotatedServiceConfigSetters;
import com.linecorp.armeria.server.DefaultServiceConfigSetters;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.MultipartRemovalStrategy;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.netty.channel.EventLoopGroup;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;

@UnstableApi
abstract class AbstractAnnotatedServiceConfigSetters<SELF extends AbstractAnnotatedServiceConfigSetters<SELF>>
implements AnnotatedServiceConfigSetters<SELF> {
    private final DefaultServiceConfigSetters defaultServiceConfigSetters = new DefaultServiceConfigSetters();
    private final ImmutableList.Builder<ExceptionHandlerFunction> exceptionHandlerFunctionBuilder = ImmutableList.builder();
    private final ImmutableList.Builder<RequestConverterFunction> requestConverterFunctionBuilder = ImmutableList.builder();
    private final ImmutableList.Builder<ResponseConverterFunction> responseConverterFunctionBuilder = ImmutableList.builder();
    @Nullable
    private String queryDelimiter;
    private boolean useBlockingTaskExecutor;
    private String pathPrefix = "/";
    @Nullable
    private Object service;
    private Set<String> contextPaths = Collections.singleton("/");

    AbstractAnnotatedServiceConfigSetters() {
    }

    final void service(Object service) {
        this.service = Objects.requireNonNull(service, "service");
    }

    final void contextPaths(Set<String> contextPaths) {
        this.contextPaths = Objects.requireNonNull(contextPaths, "contextPaths");
    }

    final SELF self() {
        return (SELF)this;
    }

    @Override
    public SELF pathPrefix(String pathPrefix) {
        this.pathPrefix = Objects.requireNonNull(pathPrefix, "pathPrefix");
        return this.self();
    }

    @Override
    public SELF exceptionHandlers(ExceptionHandlerFunction ... exceptionHandlerFunctions) {
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.exceptionHandlerFunctionBuilder.add(exceptionHandlerFunctions);
        return this.self();
    }

    @Override
    public SELF exceptionHandlers(Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions) {
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.exceptionHandlerFunctionBuilder.addAll(exceptionHandlerFunctions);
        return this.self();
    }

    @Override
    public SELF responseConverters(ResponseConverterFunction ... responseConverterFunctions) {
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        this.responseConverterFunctionBuilder.add(responseConverterFunctions);
        return this.self();
    }

    @Override
    public SELF responseConverters(Iterable<? extends ResponseConverterFunction> responseConverterFunctions) {
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        this.responseConverterFunctionBuilder.addAll(responseConverterFunctions);
        return this.self();
    }

    @Override
    public SELF requestConverters(RequestConverterFunction ... requestConverterFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        this.requestConverterFunctionBuilder.add(requestConverterFunctions);
        return this.self();
    }

    @Override
    public SELF requestConverters(Iterable<? extends RequestConverterFunction> requestConverterFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        this.requestConverterFunctionBuilder.addAll(requestConverterFunctions);
        return this.self();
    }

    @Override
    public SELF useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this.self();
    }

    @UnstableApi
    public SELF queryDelimiter(String delimiter) {
        this.queryDelimiter = Objects.requireNonNull(delimiter, "delimiter");
        return this.self();
    }

    @Override
    public SELF decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        this.defaultServiceConfigSetters.decorator((Function)decorator);
        return this.self();
    }

    @Override
    public SELF decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        this.defaultServiceConfigSetters.decorators((Function[])decorators);
        return this.self();
    }

    @Override
    public SELF decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        this.defaultServiceConfigSetters.decorators((Iterable)decorators);
        return this.self();
    }

    @Override
    public SELF requestTimeout(Duration requestTimeout) {
        this.defaultServiceConfigSetters.requestTimeout(requestTimeout);
        return this.self();
    }

    @Override
    public SELF requestTimeoutMillis(long requestTimeoutMillis) {
        this.defaultServiceConfigSetters.requestTimeoutMillis(requestTimeoutMillis);
        return this.self();
    }

    @Override
    public SELF maxRequestLength(long maxRequestLength) {
        this.defaultServiceConfigSetters.maxRequestLength(maxRequestLength);
        return this.self();
    }

    @Override
    public SELF verboseResponses(boolean verboseResponses) {
        this.defaultServiceConfigSetters.verboseResponses(verboseResponses);
        return this.self();
    }

    @Override
    public SELF accessLogFormat(String accessLogFormat) {
        this.defaultServiceConfigSetters.accessLogFormat(accessLogFormat);
        return this.self();
    }

    @Override
    public SELF accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.accessLogWriter(accessLogWriter, shutdownOnStop);
        return this.self();
    }

    @Override
    public SELF defaultServiceName(String defaultServiceName) {
        this.defaultServiceConfigSetters.defaultServiceName(defaultServiceName);
        return this.self();
    }

    @Override
    public SELF defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceConfigSetters.defaultServiceNaming(defaultServiceNaming);
        return this.self();
    }

    @Override
    public SELF defaultLogName(String defaultLogName) {
        this.defaultServiceConfigSetters.defaultLogName(defaultLogName);
        return this.self();
    }

    @Override
    public SELF blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this.self();
    }

    @Override
    public SELF blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this.self();
    }

    @Override
    public SELF blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return (SELF)this.blockingTaskExecutor(executor, true);
    }

    @Override
    public SELF successFunction(SuccessFunction successFunction) {
        this.defaultServiceConfigSetters.successFunction(successFunction);
        return this.self();
    }

    @Override
    public SELF requestAutoAbortDelay(Duration delay) {
        this.defaultServiceConfigSetters.requestAutoAbortDelay(delay);
        return this.self();
    }

    @Override
    public SELF requestAutoAbortDelayMillis(long delayMillis) {
        this.defaultServiceConfigSetters.requestAutoAbortDelayMillis(delayMillis);
        return this.self();
    }

    @Override
    public SELF multipartUploadsLocation(Path multipartUploadsLocation) {
        this.defaultServiceConfigSetters.multipartUploadsLocation(multipartUploadsLocation);
        return this.self();
    }

    @Override
    @UnstableApi
    public SELF multipartRemovalStrategy(MultipartRemovalStrategy removalStrategy) {
        this.defaultServiceConfigSetters.multipartRemovalStrategy(removalStrategy);
        return this.self();
    }

    @Override
    public SELF serviceWorkerGroup(EventLoopGroup serviceWorkerGroup, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.serviceWorkerGroup(serviceWorkerGroup, shutdownOnStop);
        return this.self();
    }

    @Override
    public SELF serviceWorkerGroup(int numThreads) {
        this.defaultServiceConfigSetters.serviceWorkerGroup(numThreads);
        return this.self();
    }

    @Override
    public SELF requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.defaultServiceConfigSetters.requestIdGenerator((Function)requestIdGenerator);
        return this.self();
    }

    @Override
    public SELF addHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.addHeader(name, value);
        return this.self();
    }

    @Override
    public SELF addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.addHeaders((Iterable)defaultHeaders);
        return this.self();
    }

    @Override
    public SELF setHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.setHeader(name, value);
        return this.self();
    }

    @Override
    public SELF setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.setHeaders((Iterable)defaultHeaders);
        return this.self();
    }

    @Override
    public SELF errorHandler(ServiceErrorHandler serviceErrorHandler) {
        this.defaultServiceConfigSetters.errorHandler(serviceErrorHandler);
        return this.self();
    }

    @Override
    public SELF contextHook(Supplier<? extends AutoCloseable> contextHook) {
        this.defaultServiceConfigSetters.contextHook((Supplier)contextHook);
        return this.self();
    }

    final List<ServiceConfigBuilder> buildServiceConfigBuilder(AnnotatedServiceExtensions extensions, DependencyInjector dependencyInjector) {
        ImmutableCollection requestConverterFunctions = ((ImmutableList.Builder)this.requestConverterFunctionBuilder.addAll(extensions.requestConverters())).build();
        ImmutableCollection responseConverterFunctions = ((ImmutableList.Builder)this.responseConverterFunctionBuilder.addAll(extensions.responseConverters())).build();
        ImmutableCollection exceptionHandlerFunctions = ((ImmutableList.Builder)this.exceptionHandlerFunctionBuilder.addAll(extensions.exceptionHandlers())).build();
        assert (this.service != null);
        List<AnnotatedServiceElement> elements = AnnotatedServiceFactory.find(this.pathPrefix, this.service, this.useBlockingTaskExecutor, (List<RequestConverterFunction>)((Object)requestConverterFunctions), (List<ResponseConverterFunction>)((Object)responseConverterFunctions), (List<ExceptionHandlerFunction>)((Object)exceptionHandlerFunctions), dependencyInjector, this.queryDelimiter);
        return elements.stream().flatMap(element -> {
            HttpService decoratedService = element.buildSafeDecoratedService(this.defaultServiceConfigSetters.decorator());
            assert (!this.contextPaths.isEmpty()) : "contextPaths shouldn't be empty";
            return this.contextPaths.stream().map(contextPath -> this.defaultServiceConfigSetters.toServiceConfigBuilder(element.route(), (String)contextPath, decoratedService));
        }).collect(ImmutableList.toImmutableList());
    }
}

