/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.SessionCacheCallback;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.model.ColumnName;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.SQLDatabaseModelExtension;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.HashMapConverter;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLBuilder;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSQLExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCSQLExecutor.class);

    protected <T extends StorageData> List<StorageData> getByIDs(JDBCClient h2Client, String modelName, List<String> ids, StorageBuilder<T> storageBuilder) throws Exception {
        ArrayList<String> tables = JDBCSQLExecutor.getModelTables(h2Client, modelName);
        ArrayList<StorageData> storageDataList = new ArrayList<StorageData>();
        for (String table : tables) {
            SQLBuilder sql = new SQLBuilder("SELECT * FROM " + table + " WHERE id in ").append(ids.stream().map(it -> "?").collect(Collectors.joining(",", "(", ")")));
            h2Client.executeQuery(sql.toString(), resultSet -> {
                StorageData storageData;
                while ((storageData = this.toStorageData(resultSet, modelName, (StorageBuilder<? extends StorageData>)storageBuilder)) != null) {
                    storageDataList.add(storageData);
                }
                return null;
            }, ids.toArray());
        }
        return storageDataList;
    }

    protected <T extends StorageData> StorageData getByID(JDBCClient h2Client, String modelName, String id, StorageBuilder<T> storageBuilder) {
        ArrayList<String> tables = JDBCSQLExecutor.getModelTables(h2Client, modelName);
        for (String table : tables) {
            StorageData result = (StorageData)h2Client.executeQuery("SELECT * FROM " + table + " WHERE id = ?", resultSet -> this.toStorageData(resultSet, modelName, (StorageBuilder<? extends StorageData>)storageBuilder), new Object[]{TableHelper.generateId(modelName, id)});
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected StorageData toStorageData(ResultSet rs, String modelName, StorageBuilder<? extends StorageData> storageBuilder) throws SQLException {
        if (rs.next()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            List columns = TableMetaInfo.get(modelName).getColumns();
            for (ModelColumn column : columns) {
                data.put(column.getColumnName().getName(), rs.getObject(column.getColumnName().getStorageName()));
            }
            return storageBuilder.storage2Entity((Convert2Entity)new HashMapConverter.ToEntity(data));
        }
        return null;
    }

    protected <T extends StorageData> SQLExecutor getInsertExecutor(Model model, T metrics, long timeBucket, StorageBuilder<T> storageBuilder, Convert2Storage<Map<String, Object>> converter, SessionCacheCallback callback) throws IOException {
        storageBuilder.entity2Storage(metrics, converter);
        Map objectMap = (Map)converter.obtain();
        HashMap<String, Object> mainEntity = new HashMap<String, Object>();
        model.getColumns().forEach(column -> mainEntity.put(column.getColumnName().getName(), objectMap.get(column.getColumnName().getName())));
        SQLExecutor sqlExecutor = this.buildInsertExecutor(model, metrics, timeBucket, mainEntity, callback);
        for (SQLDatabaseModelExtension.AdditionalTable additionalTable : model.getSqlDBModelExtension().getAdditionalTables().values()) {
            HashMap<String, Object> additionalEntity = new HashMap<String, Object>();
            additionalTable.getColumns().forEach(column -> additionalEntity.put(column.getColumnName().getName(), objectMap.get(column.getColumnName().getName())));
            List<SQLExecutor> additionalSQLExecutors = this.buildAdditionalInsertExecutor(model, additionalTable.getName(), additionalTable.getColumns(), metrics, timeBucket, additionalEntity, callback);
            sqlExecutor.appendAdditionalSQLs(additionalSQLExecutors);
        }
        return sqlExecutor;
    }

    private <T extends StorageData> SQLExecutor buildInsertExecutor(Model model, T metrics, long timeBucket, Map<String, Object> objectMap, SessionCacheCallback onCompleteCallback) {
        String table = TableHelper.getTable(model, timeBucket);
        SQLBuilder sqlBuilder = new SQLBuilder("INSERT INTO " + table);
        List columns = model.getColumns();
        List columnNames = Stream.concat(Stream.of("id", "table_name"), columns.stream().map(ModelColumn::getColumnName).map(ColumnName::getStorageName)).collect(Collectors.toList());
        sqlBuilder.append(columnNames.stream().collect(Collectors.joining(",", "(", ")")));
        sqlBuilder.append(" VALUES ");
        sqlBuilder.append(columnNames.stream().map(it -> "?").collect(Collectors.joining(",", "(", ")")));
        List<Object> param = Stream.concat(Stream.of(TableHelper.generateId(model, metrics.id().build()), model.getName()), columns.stream().map(ModelColumn::getColumnName).map(ColumnName::getName).map(objectMap::get).map(it -> {
            if (it instanceof StorageDataComplexObject) {
                return ((StorageDataComplexObject)it).toStorageData();
            }
            return it;
        })).collect(Collectors.toList());
        return new SQLExecutor(sqlBuilder.toString(), param, onCompleteCallback);
    }

    private <T extends StorageData> List<SQLExecutor> buildAdditionalInsertExecutor(Model model, String tableName, List<ModelColumn> columns, T metrics, long timeBucket, Map<String, Object> objectMap, SessionCacheCallback callback) {
        ArrayList<SQLExecutor> sqlExecutors = new ArrayList<SQLExecutor>();
        SQLBuilder sqlBuilder = new SQLBuilder("INSERT INTO ").append(TableHelper.getTable(tableName, timeBucket)).append(" VALUES ");
        ArrayList<Object> param = new ArrayList<Object>();
        sqlBuilder.append("(?,");
        param.add(TableHelper.generateId(model, metrics.id().build()));
        int position = 0;
        List valueList = new ArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            ModelColumn column = columns.get(i);
            if (List.class.isAssignableFrom(column.getType())) {
                valueList = (List)objectMap.get(column.getColumnName().getName());
                sqlBuilder.append("?");
                param.add(null);
                position = i + 1;
            } else {
                sqlBuilder.append("?");
                Object value = objectMap.get(column.getColumnName().getName());
                if (value instanceof StorageDataComplexObject) {
                    param.add(((StorageDataComplexObject)value).toStorageData());
                } else {
                    param.add(value);
                }
            }
            if (i == columns.size() - 1) continue;
            sqlBuilder.append(",");
        }
        sqlBuilder.append(")");
        String sql = sqlBuilder.toString();
        if (!CollectionUtils.isEmpty(valueList)) {
            for (Object object : valueList) {
                ArrayList<Object> paramCopy = new ArrayList<Object>(param);
                paramCopy.set(position, object);
                sqlExecutors.add(new SQLExecutor(sql, paramCopy, callback));
            }
        } else {
            sqlExecutors.add(new SQLExecutor(sql, param, callback));
        }
        return sqlExecutors;
    }

    protected <T extends StorageData> SQLExecutor getUpdateExecutor(Model model, T metrics, long timeBucket, StorageBuilder<T> storageBuilder, SessionCacheCallback callback) {
        HashMapConverter.ToStorage toStorage = new HashMapConverter.ToStorage();
        storageBuilder.entity2Storage(metrics, (Convert2Storage)toStorage);
        Map objectMap = toStorage.obtain();
        String table = TableHelper.getTable(model, timeBucket);
        StringBuilder sqlBuilder = new StringBuilder("UPDATE " + table + " SET ");
        List columns = model.getColumns();
        ArrayList<CallSite> queries = new ArrayList<CallSite>();
        ArrayList<Object> param = new ArrayList<Object>();
        for (ModelColumn column : columns) {
            String columnName = column.getColumnName().getName();
            queries.add((CallSite)((Object)(column.getColumnName().getStorageName() + " = ?")));
            Object value = objectMap.get(columnName);
            if (value instanceof StorageDataComplexObject) {
                param.add(((StorageDataComplexObject)value).toStorageData());
                continue;
            }
            param.add(value);
        }
        sqlBuilder.append(queries.stream().collect(Collectors.joining(", ")));
        sqlBuilder.append(" WHERE id = ?");
        param.add(TableHelper.generateId(model, metrics.id().build()));
        return new SQLExecutor(sqlBuilder.toString(), param, callback);
    }

    private static ArrayList<String> getModelTables(JDBCClient h2Client, String modelName) throws Exception {
        Model model = TableMetaInfo.get(modelName);
        String tableNamePattern = TableHelper.getTableName(model) + "%";
        ArrayList<String> tables = new ArrayList<String>();
        try (Connection connection = h2Client.getConnection();
             ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), tableNamePattern, new String[]{"TABLE"});){
            while (resultSet.next()) {
                tables.add(resultSet.getString("TABLE_NAME"));
            }
        }
        return tables;
    }
}

