/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.event.Event;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class EventQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IEventQueryDAO dao;

    public EventQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IEventQueryDAO getDao() {
        if (this.dao == null) {
            this.dao = (IEventQueryDAO)this.moduleManager.find("storage").provider().getService(IEventQueryDAO.class);
        }
        return this.dao;
    }

    public Events queryEvents(EventQueryCondition condition) throws Exception {
        if (StringUtil.isBlank((String)condition.getUuid()) && this.isDurationInvalid(condition.getTime())) {
            throw new IllegalArgumentException("time field is required when uuid is absent.");
        }
        Events events = this.getDao().queryEvents(condition);
        return this.mergeAndSortEvents(events, condition.getOrder());
    }

    public Events queryEvents(List<EventQueryCondition> conditions) throws Exception {
        EventQueryCondition condition = conditions.stream().filter(c -> StringUtil.isBlank((String)c.getUuid()) && this.isDurationInvalid(c.getTime())).findFirst().orElse(null);
        if (Objects.nonNull(condition)) {
            throw new IllegalArgumentException("time field is required when uuid is absent.");
        }
        Events events = this.getDao().queryEvents(conditions);
        return this.mergeAndSortEvents(events, conditions.get(0).getOrder());
    }

    boolean isDurationInvalid(Duration duration) {
        return Objects.isNull(duration) || StringUtil.isBlank((String)duration.getStart()) || StringUtil.isBlank((String)duration.getEnd());
    }

    private Events mergeAndSortEvents(Events events, Order order) {
        Order queryOrder = Objects.isNull((Object)order) ? Order.DES : order;
        HashMap<String, Event> mergedEvents = new HashMap<String, Event>();
        for (Event event : events.getEvents()) {
            String key = event.getUuid();
            if (!mergedEvents.containsKey(key)) {
                mergedEvents.put(key, event);
                continue;
            }
            Event existingEvent = (Event)mergedEvents.get(key);
            if (event.getStartTime() > 0L && existingEvent.getStartTime() > event.getStartTime() || existingEvent.getStartTime() == 0L) {
                existingEvent.setStartTime(event.getStartTime());
                if (existingEvent.getEndTime() != 0L) continue;
                existingEvent.setTimestamp(event.getTimestamp());
                continue;
            }
            if (event.getEndTime() <= 0L || existingEvent.getEndTime() >= event.getEndTime()) continue;
            event.setStartTime(existingEvent.getStartTime());
            mergedEvents.put(key, event);
        }
        List<Event> sortedEvents = queryOrder == Order.ASC ? mergedEvents.values().stream().sorted(Comparator.comparing(Event::getTimestamp)).collect(Collectors.toList()) : mergedEvents.values().stream().sorted(Comparator.comparing(Event::getTimestamp).reversed()).collect(Collectors.toList());
        return new Events(sortedEvents);
    }
}

