/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractUnframedGrpcService
extends SimpleDecoratingHttpService
implements GrpcService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractUnframedGrpcService.class);
    static final AttributeKey<Boolean> IS_UNFRAMED_GRPC = AttributeKey.valueOf(AbstractUnframedGrpcService.class, (String)"IS_UNFRAMED_GRPC");
    private final GrpcService delegate;
    private final UnframedGrpcErrorHandler unframedGrpcErrorHandler;

    AbstractUnframedGrpcService(GrpcService delegate, UnframedGrpcErrorHandler unframedGrpcErrorHandler) {
        super((HttpService)delegate);
        this.delegate = delegate;
        this.unframedGrpcErrorHandler = Objects.requireNonNull(unframedGrpcErrorHandler, "unframedGrpcErrorHandler");
    }

    public Set<Route> routes() {
        return this.delegate.routes();
    }

    public ExchangeType exchangeType(RoutingContext routingContext) {
        MediaType contentType = routingContext.headers().contentType();
        if (contentType == null) {
            return ExchangeType.BIDI_STREAMING;
        }
        for (SerializationFormat format : GrpcSerializationFormats.values()) {
            if (!format.isAccepted(contentType)) continue;
            return ((HttpService)this.unwrap()).exchangeType(routingContext);
        }
        if (contentType.is(MediaType.PROTOBUF) || contentType.is(MediaType.JSON_UTF_8)) {
            return ExchangeType.UNARY;
        }
        return ExchangeType.BIDI_STREAMING;
    }

    @Override
    public boolean isFramed() {
        return false;
    }

    @Override
    public Map<String, ServerMethodDefinition<?, ?>> methods() {
        return this.delegate.methods();
    }

    @Override
    public Map<Route, ServerMethodDefinition<?, ?>> methodsByRoute() {
        return this.delegate.methodsByRoute();
    }

    @Override
    public List<ServerServiceDefinition> services() {
        return this.delegate.services();
    }

    @Override
    public Set<SerializationFormat> supportedSerializationFormats() {
        return this.delegate.supportedSerializationFormats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void frameAndServe(Service<HttpRequest, HttpResponse> delegate, ServiceRequestContext ctx, RequestHeaders grpcHeaders, HttpData content, CompletableFuture<HttpResponse> res, @Nullable Function<AggregatedHttpResponse, AggregatedHttpResponse> responseConverter) {
        HttpResponse grpcResponse;
        HttpRequest grpcRequest;
        ctx.setAttr(IS_UNFRAMED_GRPC, (Object)true);
        try (ArmeriaMessageFramer framer = new ArmeriaMessageFramer(ctx.alloc(), -1, false);){
            HttpData frame;
            boolean success = false;
            try {
                frame = framer.writePayload(content.byteBuf());
                success = true;
            }
            finally {
                if (!success) {
                    content.close();
                }
            }
            grpcRequest = HttpRequest.of((RequestHeaders)grpcHeaders, (HttpData)frame);
        }
        try {
            grpcResponse = (HttpResponse)delegate.serve(ctx, (Request)grpcRequest);
        }
        catch (Exception e) {
            res.completeExceptionally(e);
            return;
        }
        grpcResponse.aggregate(AggregationOptions.usePooledObjects((ByteBufAllocator)ctx.alloc(), (EventExecutor)ctx.eventLoop())).handle((framedResponse, t) -> {
            try (SafeCloseable ignore = ctx.push();){
                if (t != null) {
                    res.completeExceptionally((Throwable)t);
                } else {
                    AbstractUnframedGrpcService.deframeAndRespond(ctx, framedResponse, res, this.unframedGrpcErrorHandler, responseConverter);
                }
            }
            return null;
        });
    }

    @VisibleForTesting
    static void deframeAndRespond(ServiceRequestContext ctx, AggregatedHttpResponse grpcResponse, CompletableFuture<HttpResponse> res, UnframedGrpcErrorHandler unframedGrpcErrorHandler, @Nullable Function<AggregatedHttpResponse, AggregatedHttpResponse> responseConverter) {
        Object trailers = !grpcResponse.trailers().isEmpty() ? grpcResponse.trailers() : grpcResponse.headers();
        String grpcStatusCode = trailers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        if (grpcStatusCode == null) {
            PooledObjects.close((Object)grpcResponse.content());
            res.completeExceptionally(new NullPointerException("grpcStatusCode must not be null"));
            logger.warn("{} A gRPC response must have the {} header. response: {}", new Object[]{ctx, GrpcHeaderNames.GRPC_STATUS, grpcResponse});
            return;
        }
        Status grpcStatus = Status.fromCodeValue((int)Integer.parseInt(grpcStatusCode));
        String grpcMessage = trailers.get((CharSequence)GrpcHeaderNames.GRPC_MESSAGE);
        if (!Strings.isNullOrEmpty((String)grpcMessage)) {
            grpcStatus = grpcStatus.withDescription(grpcMessage);
        }
        if (grpcStatus.getCode() != Status.Code.OK) {
            PooledObjects.close((Object)grpcResponse.content());
            try {
                res.complete(unframedGrpcErrorHandler.handle(ctx, grpcStatus, grpcResponse));
            }
            catch (Exception e) {
                res.completeExceptionally(e);
            }
            return;
        }
        MediaType grpcMediaType = grpcResponse.contentType();
        if (grpcMediaType == null) {
            PooledObjects.close((Object)grpcResponse.content());
            res.completeExceptionally(new NullPointerException("MediaType is undefined"));
            return;
        }
        ResponseHeadersBuilder unframedHeaders = grpcResponse.headers().toBuilder();
        unframedHeaders.set((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcStatusCode);
        ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(Integer.MAX_VALUE);
        Subscriber<DeframedMessage> subscriber = AbstractUnframedGrpcService.singleSubscriber(unframedHeaders, res, responseConverter);
        grpcResponse.toHttpResponse().decode((HttpDecoder)deframer, ctx.alloc()).subscribe(subscriber, (EventExecutor)ctx.eventLoop(), new SubscriptionOption[]{SubscriptionOption.WITH_POOLED_OBJECTS});
    }

    static Subscriber<DeframedMessage> singleSubscriber(final ResponseHeadersBuilder unframedHeaders, final CompletableFuture<HttpResponse> res, final @Nullable Function<AggregatedHttpResponse, AggregatedHttpResponse> responseConverter) {
        return new Subscriber<DeframedMessage>(){

            public void onSubscribe(Subscription subscription) {
                subscription.request(1L);
            }

            public void onNext(DeframedMessage message) {
                ByteBuf buf = message.buf();
                assert (buf != null);
                HttpData unframedContent = HttpData.wrap((ByteBuf)buf);
                unframedHeaders.contentType(MediaType.JSON_UTF_8);
                AggregatedHttpResponse existingResponse = AggregatedHttpResponse.of((ResponseHeaders)unframedHeaders.build(), (HttpData)unframedContent);
                if (responseConverter != null) {
                    AggregatedHttpResponse convertedResponse = (AggregatedHttpResponse)responseConverter.apply(existingResponse);
                    res.complete(convertedResponse.toHttpResponse());
                } else {
                    res.complete(existingResponse.toHttpResponse());
                }
            }

            public void onError(Throwable t) {
                if (!res.isDone()) {
                    res.completeExceptionally(t);
                }
            }

            public void onComplete() {
                if (!res.isDone()) {
                    res.complete(HttpResponse.of((ResponseHeaders)unframedHeaders.build()));
                }
            }
        };
    }
}

