/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.util.Comparator;
import java.util.Locale;
import javax.xml.namespace.QName;

public class QNameComparator
implements Comparator<QName> {
    public static final QNameComparator INSTANCE = new QNameComparator();
    private static final int LESS_THAN = -1;
    private static final int EQUAL = 0;
    private static final int GREATER_THAN = 1;

    @Override
    public int compare(QName o1, QName o2) {
        String lowerCaseQName2;
        boolean isXmlNs1 = o1.getPrefix().equalsIgnoreCase("xml");
        boolean isXmlNs2 = o2.getPrefix().equalsIgnoreCase("xml");
        if (isXmlNs1 && !isXmlNs2) {
            return -1;
        }
        if (!isXmlNs1 && isXmlNs2) {
            return 1;
        }
        if (!o1.getPrefix().equalsIgnoreCase("") && o2.getPrefix().equalsIgnoreCase("")) {
            return -1;
        }
        if (o1.getPrefix().equalsIgnoreCase("") && !o2.getPrefix().equalsIgnoreCase("")) {
            return 1;
        }
        String lowerCaseQName1 = o1.getPrefix().toLowerCase(Locale.ROOT) + o1.getLocalPart().toLowerCase(Locale.ROOT);
        int c = lowerCaseQName1.compareTo(lowerCaseQName2 = o2.getPrefix().toLowerCase(Locale.ROOT) + o2.getLocalPart().toLowerCase(Locale.ROOT));
        if (c == 0) {
            String qName1 = o1.getPrefix() + o1.getLocalPart();
            String qName2 = o2.getPrefix() + o2.getLocalPart();
            return qName1.compareTo(qName2);
        }
        return c;
    }
}

