/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;

@Internal
public class LegacySinkTransformation<T>
extends PhysicalTransformation<T> {
    private final Transformation<T> input;
    private final StreamOperatorFactory<Object> operatorFactory;
    private KeySelector<T, ?> stateKeySelector;
    private TypeInformation<?> stateKeyType;

    public LegacySinkTransformation(Transformation<T> input, String name, StreamSink<T> operator, int parallelism) {
        this(input, name, SimpleOperatorFactory.of(operator), parallelism);
    }

    public LegacySinkTransformation(Transformation<T> input, String name, StreamOperatorFactory<Object> operatorFactory, int parallelism) {
        super(name, input.getOutputType(), parallelism);
        this.input = input;
        this.operatorFactory = operatorFactory;
    }

    @VisibleForTesting
    public StreamSink<T> getOperator() {
        return (StreamSink)((SimpleOperatorFactory)this.operatorFactory).getOperator();
    }

    public StreamOperatorFactory<Object> getOperatorFactory() {
        return this.operatorFactory;
    }

    public void setStateKeySelector(KeySelector<T, ?> stateKeySelector) {
        this.stateKeySelector = stateKeySelector;
        this.updateManagedMemoryStateBackendUseCase(stateKeySelector != null);
    }

    public KeySelector<T, ?> getStateKeySelector() {
        return this.stateKeySelector;
    }

    public void setStateKeyType(TypeInformation<?> stateKeyType) {
        this.stateKeyType = stateKeyType;
    }

    public TypeInformation<?> getStateKeyType() {
        return this.stateKeyType;
    }

    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operatorFactory.setChainingStrategy(strategy);
    }
}

