/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels.any;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.rest.GroupRestClient;
import org.apache.syncope.client.ui.commons.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.wizards.any.AbstractGroupsModel;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class Groups
extends Panel {
    private static final long serialVersionUID = 552437609667518888L;
    protected static final int MAX_GROUP_LIST_CARDINALITY = 30;
    @SpringBean
    protected GroupRestClient groupRestClient;
    protected final EnduserGroupsModel groupsModel;
    protected final AnyTO anyTO;
    protected WebMarkupContainer dyngroupsContainer;
    protected WebMarkupContainer dynrealmsContainer;
    protected WebMarkupContainer groupsContainer;

    public <T extends AnyTO> Groups(String id, AnyWrapper<T> modelObject) {
        super(id);
        UserWrapper uw;
        this.anyTO = (AnyTO)modelObject.getInnerObject();
        this.setOutputMarkupId(true);
        this.groupsContainer = new WebMarkupContainer("groupsContainer");
        this.groupsContainer.setOutputMarkupId(true);
        this.groupsContainer.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{this.groupsContainer});
        if (modelObject instanceof UserWrapper && (uw = (UserWrapper)modelObject).getPreviousUserTO() != null && !ListUtils.isEqualList((Collection)((UserTO)uw.getInnerObject()).getMemberships(), (Collection)uw.getPreviousUserTO().getMemberships())) {
            this.groupsContainer.add(new Component[]{new LabelInfo("changed", "")});
        } else {
            this.groupsContainer.add(new Component[]{new Label("changed", (Serializable)((Object)""))});
        }
        this.groupsModel = new EnduserGroupsModel();
        this.setOutputMarkupId(true);
        this.addDynamicGroupsContainer();
        this.addGroupsPanel();
        this.addDynamicRealmsContainer();
    }

    protected SerializableFunction<AjaxRequestTarget, Boolean> getEventFunction() {
        return (SerializableFunction & Serializable)target -> {
            this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new AjaxPalettePanel.UpdateActionEvent((UserTO)this.anyTO, target));
            return true;
        };
    }

    protected void addGroupsPanel() {
        if (this.anyTO instanceof GroupTO) {
            this.groupsContainer.add(new Component[]{new Label("groups").setVisible(false)});
            this.groupsContainer.setVisible(false);
        } else {
            AjaxPalettePanel.Builder builder = new AjaxPalettePanel.Builder().setRenderer((IChoiceRenderer)new IChoiceRenderer<MembershipTO>(){
                private static final long serialVersionUID = -3086661086073628855L;

                public Object getDisplayValue(MembershipTO object) {
                    return object.getGroupName();
                }

                public String getIdValue(MembershipTO object, int index) {
                    return object.getGroupName();
                }

                public MembershipTO getObject(String id, IModel<? extends List<? extends MembershipTO>> choices) {
                    return ((List)choices.getObject()).stream().filter(object -> id.equalsIgnoreCase(object.getGroupName())).findAny().orElse(null);
                }
            }).event(this.getEventFunction());
            this.groupsContainer.add(new Component[]{builder.setAllowOrder(true).withFilter().build("groups", (IModel)new ListModel<MembershipTO>(){
                private static final long serialVersionUID = -2583290457773357445L;

                public List<MembershipTO> getObject() {
                    return Groups.this.groupsModel.getMemberships();
                }
            }, (AjaxPalettePanel.Builder.Query)new AjaxPalettePanel.Builder.Query<MembershipTO>(){
                private static final long serialVersionUID = -7223078772249308813L;

                public List<MembershipTO> execute(String filter) {
                    return (StringUtils.isEmpty((CharSequence)filter) || "*".equals(filter) ? Groups.this.groupsModel.getObject() : Groups.this.groupRestClient.searchAssignableGroups(Groups.this.anyTO.getRealm(), filter, 1, 30)).stream().map(input -> new MembershipTO.Builder(input.getKey()).groupName(input.getName()).build()).collect(Collectors.toList());
                }
            }).hideLabel().setOutputMarkupId(true)});
        }
    }

    protected void addDynamicRealmsContainer() {
    }

    protected void addDynamicGroupsContainer() {
    }

    protected class EnduserGroupsModel
    extends AbstractGroupsModel {
        private static final long serialVersionUID = -4541954630939063927L;

        protected EnduserGroupsModel() {
        }

        protected void reloadObject() {
            this.groups = Groups.this.groupRestClient.searchAssignableGroups("/", null, 1, 30);
        }

        protected void reloadMemberships() {
            this.memberships = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships();
        }

        protected void reloadDynMemberships() {
        }

        public List<String> getDynMemberships() {
            return List.of();
        }
    }
}

