/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.utilities;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ColorBehavior
extends BootstrapBaseBehavior {
    private IModel<Color> colorModel;

    public ColorBehavior(Color color) {
        this((IModel<Color>)Model.of((Serializable)((Object)color)));
    }

    public ColorBehavior(IModel<Color> colorModel) {
        this.colorModel = colorModel;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, (ICssClassNameProvider)this.colorModel.getObject());
    }

    public ColorBehavior color(Color color) {
        this.colorModel.setObject((Object)color);
        return this;
    }

    public ColorBehavior color(IModel<Color> colorModel) {
        this.colorModel = colorModel;
        return this;
    }

    public Color getColor() {
        return (Color)this.colorModel.getObject();
    }

    public IModel<Color> getColorModel() {
        return this.colorModel;
    }

    public static ColorBehavior primary() {
        return new ColorBehavior(Color.Primary);
    }

    public static ColorBehavior primaryEmphasis() {
        return new ColorBehavior(Color.Primary_emphasis);
    }

    public static ColorBehavior secondary() {
        return new ColorBehavior(Color.Secondary);
    }

    public static ColorBehavior secondaryEmphasis() {
        return new ColorBehavior(Color.Secondary_emphasis);
    }

    public static ColorBehavior success() {
        return new ColorBehavior(Color.Success);
    }

    public static ColorBehavior successEmphasis() {
        return new ColorBehavior(Color.Success_emphasis);
    }

    public static ColorBehavior danger() {
        return new ColorBehavior(Color.Danger);
    }

    public static ColorBehavior dangerEmphasis() {
        return new ColorBehavior(Color.Danger_emphasis);
    }

    public static ColorBehavior warning() {
        return new ColorBehavior(Color.Warning);
    }

    public static ColorBehavior warningEmphasis() {
        return new ColorBehavior(Color.Warning_emphasis);
    }

    public static ColorBehavior info() {
        return new ColorBehavior(Color.Info);
    }

    public static ColorBehavior infoEmphasis() {
        return new ColorBehavior(Color.Info_emphasis);
    }

    public static ColorBehavior light() {
        return new ColorBehavior(Color.Light);
    }

    public static ColorBehavior lightEmphasis() {
        return new ColorBehavior(Color.Light_emphasis);
    }

    public static ColorBehavior dark() {
        return new ColorBehavior(Color.Dark);
    }

    public static ColorBehavior darkEmphasis() {
        return new ColorBehavior(Color.Dark_emphasis);
    }

    public static ColorBehavior body() {
        return new ColorBehavior(Color.Body);
    }

    public static ColorBehavior bodyEmphasis() {
        return new ColorBehavior(Color.Body_emphasis);
    }

    public static ColorBehavior bodySecondary() {
        return new ColorBehavior(Color.Body_secondary);
    }

    public static ColorBehavior bodyTertiary() {
        return new ColorBehavior(Color.Body_tertiary);
    }

    public static ColorBehavior white() {
        return new ColorBehavior(Color.White);
    }

    public static ColorBehavior black() {
        return new ColorBehavior(Color.Black);
    }

    public static ColorBehavior black50() {
        return new ColorBehavior(Color.Black50);
    }

    public static ColorBehavior white50() {
        return new ColorBehavior(Color.White50);
    }

    public static enum Color implements ICssClassNameProvider
    {
        Primary("primary"),
        Primary_emphasis("primary-emphasis"),
        Secondary("secondary"),
        Secondary_emphasis("secondary-emphasis"),
        Success("success"),
        Success_emphasis("success-emphasis"),
        Danger("danger"),
        Danger_emphasis("danger-emphasis"),
        Warning("warning"),
        Warning_emphasis("warning-emphasis"),
        Info("info"),
        Info_emphasis("info-emphasis"),
        Light("light"),
        Light_emphasis("light-emphasis"),
        Dark("dark"),
        Dark_emphasis("dark-emphasis"),
        Body("body"),
        Body_emphasis("body-emphasis"),
        Body_secondary("body-secondary"),
        Body_tertiary("body-tertiary"),
        White("white"),
        Black("black"),
        Black50("black-50"),
        White50("white-50");

        private final String cssClassName;

        private Color(String value) {
            this.cssClassName = "text-" + value;
        }

        @Override
        public String cssClassName() {
            return this.cssClassName;
        }
    }
}

