/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.security.impl.RandomIdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.SecureRandomIdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.Type4UUIDIdentifierGenerationStrategy;

@ThreadSafe
public interface IdentifierGenerationStrategy {
    @Nonnull
    @NotEmpty
    public String generateIdentifier();

    @Nonnull
    @NotEmpty
    public String generateIdentifier(boolean var1);

    @Nonnull
    public static IdentifierGenerationStrategy getInstance(@Nonnull ProviderType type) {
        switch (type) {
            case SECURE: {
                return new SecureRandomIdentifierGenerationStrategy();
            }
            case UUID: {
                return new Type4UUIDIdentifierGenerationStrategy();
            }
        }
        return new RandomIdentifierGenerationStrategy();
    }

    @Nonnull
    public static IdentifierGenerationStrategy getInstance(@Nonnull ProviderType type, @Nonnull ParameterSpec params) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        switch (type) {
            case RANDOM: {
                return new RandomIdentifierGenerationStrategy(params);
            }
            case SECURE: {
                return new SecureRandomIdentifierGenerationStrategy(params);
            }
            case UUID: {
                return new Type4UUIDIdentifierGenerationStrategy(params);
            }
        }
        throw new NoSuchAlgorithmException("Unknown IdentifierGenerationStrategy type");
    }

    public static enum ProviderType {
        RANDOM,
        SECURE,
        UUID;

    }

    public static interface ParameterSpec {
    }
}

