/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.record;

import org.apache.uniffle.shaded.com.google.common.base.Objects;

public class Record<K, V> {
    private K key;
    private V value;

    private Record(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> Record create(K key, V value) {
        return new Record<K, V>(key, value);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public String toString() {
        return "Record{key=" + this.key + ", value=" + this.value + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Record record = (Record)o;
        return Objects.equal(this.key, record.key) && Objects.equal(this.value, record.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.key, this.value);
    }
}

