/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.shuffle;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.security.Credentials;
import org.apache.uniffle.client.record.Record;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.serializer.SerializerInstance;

class RecordCollector<K extends WritableComparable, V extends Writable>
implements ReduceContext<K, V, K, V> {
    private final Iterator<Map.Entry<DataOutputBuffer, List<Record<DataOutputBuffer, DataOutputBuffer>>>> oldRecords;
    private final List<Record<DataOutputBuffer, DataOutputBuffer>> newRecords;
    private DataOutputBuffer currentKey;
    private List<Record<DataOutputBuffer, DataOutputBuffer>> currentValues;
    private final SerializerInstance serializerInstance;
    private final Class<K> keyClass;
    private final Class<V> valueClass;

    RecordCollector(Iterator<Map.Entry<DataOutputBuffer, List<Record<DataOutputBuffer, DataOutputBuffer>>>> oldRecords, List<Record<DataOutputBuffer, DataOutputBuffer>> newRecords, SerializerInstance serializerInstance, Class<K> keyClass, Class<V> valueClass) {
        this.oldRecords = oldRecords;
        this.newRecords = newRecords;
        this.serializerInstance = serializerInstance;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    public boolean nextKey() throws IOException, InterruptedException {
        boolean ret = this.oldRecords.hasNext();
        if (ret) {
            Map.Entry<DataOutputBuffer, List<Record<DataOutputBuffer, DataOutputBuffer>>> entry = this.oldRecords.next();
            this.currentKey = entry.getKey();
            this.currentValues = entry.getValue();
        }
        return ret;
    }

    public Iterable<V> getValues() throws IOException, InterruptedException {
        final Iterator<Record<DataOutputBuffer, DataOutputBuffer>> currentValuesIterator = this.currentValues.iterator();
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return currentValuesIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        try {
                            DataOutputBuffer valueBuffer = (DataOutputBuffer)((Record)currentValuesIterator.next()).getValue();
                            DataInputBuffer valueInputBuffer = new DataInputBuffer();
                            valueInputBuffer.reset(valueBuffer.getData(), 0, valueBuffer.getLength());
                            return (Writable)RecordCollector.this.serializerInstance.deserialize(valueInputBuffer, RecordCollector.this.valueClass);
                        }
                        catch (IOException e) {
                            throw new RssException(e);
                        }
                    }
                };
            }
        };
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return false;
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        DataInputBuffer keyInputBuffer = new DataInputBuffer();
        keyInputBuffer.reset(this.currentKey.getData(), 0, this.currentKey.getLength());
        return (K)((WritableComparable)this.serializerInstance.deserialize(keyInputBuffer, this.keyClass));
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return null;
    }

    public void write(K key, V value) throws IOException, InterruptedException {
        DataOutputBuffer keyBuffer = new DataOutputBuffer();
        DataOutputBuffer valueBuffer = new DataOutputBuffer();
        this.serializerInstance.serialize(key, (DataOutputStream)keyBuffer);
        this.serializerInstance.serialize(value, (DataOutputStream)valueBuffer);
        this.newRecords.add(Record.create(keyBuffer, valueBuffer));
    }

    public OutputCommitter getOutputCommitter() {
        return null;
    }

    public TaskAttemptID getTaskAttemptID() {
        return null;
    }

    public void setStatus(String s) {
    }

    public String getStatus() {
        return null;
    }

    public float getProgress() {
        return 0.0f;
    }

    public Counter getCounter(Enum<?> anEnum) {
        return null;
    }

    public Counter getCounter(String s, String s1) {
        return null;
    }

    public Configuration getConfiguration() {
        return null;
    }

    public Credentials getCredentials() {
        return null;
    }

    public JobID getJobID() {
        return null;
    }

    public int getNumReduceTasks() {
        return 0;
    }

    public Path getWorkingDirectory() throws IOException {
        return null;
    }

    public Class<?> getOutputKeyClass() {
        return null;
    }

    public Class<?> getOutputValueClass() {
        return null;
    }

    public Class<?> getMapOutputKeyClass() {
        return null;
    }

    public Class<?> getMapOutputValueClass() {
        return null;
    }

    public String getJobName() {
        return null;
    }

    public Class<? extends InputFormat<?, ?>> getInputFormatClass() throws ClassNotFoundException {
        return null;
    }

    public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() throws ClassNotFoundException {
        return null;
    }

    public Class<? extends Reducer<?, ?, ?, ?>> getCombinerClass() throws ClassNotFoundException {
        return null;
    }

    public Class<? extends Reducer<?, ?, ?, ?>> getReducerClass() throws ClassNotFoundException {
        return null;
    }

    public Class<? extends OutputFormat<?, ?>> getOutputFormatClass() throws ClassNotFoundException {
        return null;
    }

    public Class<? extends Partitioner<?, ?>> getPartitionerClass() throws ClassNotFoundException {
        return null;
    }

    public RawComparator<?> getSortComparator() {
        return null;
    }

    public String getJar() {
        return null;
    }

    public RawComparator<?> getCombinerKeyGroupingComparator() {
        return null;
    }

    public RawComparator<?> getGroupingComparator() {
        return null;
    }

    public boolean getJobSetupCleanupNeeded() {
        return false;
    }

    public boolean getTaskCleanupNeeded() {
        return false;
    }

    public boolean getProfileEnabled() {
        return false;
    }

    public String getProfileParams() {
        return null;
    }

    public Configuration.IntegerRanges getProfileTaskRange(boolean b) {
        return null;
    }

    public String getUser() {
        return null;
    }

    public boolean getSymlink() {
        return false;
    }

    public Path[] getArchiveClassPaths() {
        return new Path[0];
    }

    public URI[] getCacheArchives() throws IOException {
        return new URI[0];
    }

    public URI[] getCacheFiles() throws IOException {
        return new URI[0];
    }

    public Path[] getLocalCacheArchives() throws IOException {
        return new Path[0];
    }

    public Path[] getLocalCacheFiles() throws IOException {
        return new Path[0];
    }

    public Path[] getFileClassPaths() {
        return new Path[0];
    }

    public String[] getArchiveTimestamps() {
        return new String[0];
    }

    public String[] getFileTimestamps() {
        return new String[0];
    }

    public int getMaxMapAttempts() {
        return 0;
    }

    public int getMaxReduceAttempts() {
        return 0;
    }

    public void progress() {
    }
}

