/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.uniffle.common.ReconfigurableRegistry;
import org.apache.uniffle.common.config.ConfigOption;
import org.apache.uniffle.common.config.ConfigUtils;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconfigurableConfManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconfigurableConfManager.class);
    private static ReconfigurableConfManager reconfigurableConfManager;
    private RssConf rssConf;
    private ScheduledExecutorService scheduledThreadPoolExecutor;
    private List<ConfigOption<T>> updateConfOptions;
    private long latestModificationTimestamp;

    private ReconfigurableConfManager(RssConf rssConf, String rssConfFilePath, Class confCls) {
        Supplier<RssConf> confSupplier = this.getConfFromFile(rssConfFilePath, confCls);
        this.initialize(rssConf, confSupplier);
    }

    private ReconfigurableConfManager(RssConf rssConf, Supplier<RssConf> confSupplier) {
        this.initialize(rssConf, confSupplier);
    }

    private void initialize(RssConf rssConf, Supplier<RssConf> confSupplier) {
        this.rssConf = rssConf;
        if (confSupplier != null) {
            this.updateConfOptions = new ArrayList<ConfigOption<T>>();
            this.scheduledThreadPoolExecutor = ThreadUtils.getDaemonSingleThreadScheduledExecutor("Refresh-rss-conf");
            LOGGER.info("Starting scheduled reconfigurable conf checker...");
            this.scheduledThreadPoolExecutor.scheduleAtFixedRate(() -> {
                try {
                    RssConf latestConf = (RssConf)confSupplier.get();
                    this.update(latestConf);
                }
                catch (Exception e) {
                    LOGGER.error("Errors on refreshing the rss conf.", (Throwable)e);
                }
            }, 1L, rssConf.get(RssBaseConf.RSS_RECONFIGURE_INTERVAL_SEC), TimeUnit.SECONDS);
        }
    }

    private Supplier<RssConf> getConfFromFile(String rssConfFilePath, Class confCls) {
        return () -> {
            File confFile = new File(rssConfFilePath);
            if (!confFile.exists()) {
                LOGGER.warn("Rss conf file: {} don't exist. Ignore updating", (Object)rssConfFilePath);
                return null;
            }
            if (!confFile.isFile()) {
                LOGGER.warn("Rss conf file: {} is not file. Ignore updating", (Object)rssConfFilePath);
                return null;
            }
            long lastModified = confFile.lastModified();
            if (lastModified > this.latestModificationTimestamp) {
                this.latestModificationTimestamp = lastModified;
                RssBaseConf conf = new RssBaseConf();
                conf.loadConfFromFile(rssConfFilePath, ConfigUtils.getAllConfigOptions(confCls));
                return conf;
            }
            return null;
        };
    }

    private void update(RssConf latestConf) {
        if (latestConf == null) {
            return;
        }
        HashSet<String> changedProperties = new HashSet<String>();
        for (ConfigOption<T> configOption : this.updateConfOptions) {
            Optional<T> valOptional = latestConf.getOptional(configOption);
            if (valOptional.isPresent()) {
                T val = valOptional.get();
                if (Objects.equals(val, this.rssConf.get(configOption))) continue;
                LOGGER.info("Update the config option: {} from {} -> {}", new Object[]{configOption.key(), this.rssConf.get(configOption), val});
                this.rssConf.set(configOption, val);
                changedProperties.add(configOption.key());
                continue;
            }
            if (!this.rssConf.isSet(configOption.key())) continue;
            this.rssConf.remove(configOption.key());
            changedProperties.add(configOption.key());
        }
        if (!changedProperties.isEmpty()) {
            ReconfigurableRegistry.update(this.rssConf, Collections.unmodifiableSet(changedProperties));
        }
    }

    private RssConf getConfRef() {
        return this.rssConf;
    }

    private void registerInternal(ConfigOption<T> configOption) {
        this.updateConfOptions.add(configOption);
    }

    public static void init(RssConf rssConf, String rssConfFilePath) {
        ReconfigurableConfManager manager;
        reconfigurableConfManager = manager = new ReconfigurableConfManager(rssConf, rssConfFilePath, rssConf.getClass());
    }

    @VisibleForTesting
    protected static void initForTest(RssConf rssConf, Supplier<RssConf> confSupplier) {
        ReconfigurableConfManager manager;
        reconfigurableConfManager = manager = new ReconfigurableConfManager(rssConf, confSupplier);
    }

    public static <T> Reconfigurable<T> register(RssConf conf, ConfigOption<T> configOption) {
        if (reconfigurableConfManager == null) {
            LOGGER.warn("{} is not initialized. The conf of [{}] will not be updated.", (Object)ReconfigurableConfManager.class.getSimpleName(), (Object)configOption.key());
            return new FixedReconfigurable<T>(conf, configOption);
        }
        reconfigurableConfManager.registerInternal(configOption);
        Reconfigurable<T> reconfigurable = new Reconfigurable<T>(reconfigurableConfManager, configOption);
        return reconfigurable;
    }

    public static class Reconfigurable<T> {
        ReconfigurableConfManager reconfigurableConfManager;
        ConfigOption<T> option;

        Reconfigurable() {
        }

        Reconfigurable(ReconfigurableConfManager reconfigurableConfManager, ConfigOption<T> option) {
            this.reconfigurableConfManager = reconfigurableConfManager;
            this.option = option;
        }

        public T get() {
            return this.reconfigurableConfManager.getConfRef().get(this.option);
        }

        public long getSizeAsBytes() {
            return this.reconfigurableConfManager.getConfRef().getSizeAsBytes(this.option);
        }
    }

    public static class FixedReconfigurable<T>
    extends Reconfigurable<T> {
        RssConf conf;
        ConfigOption<T> option;

        FixedReconfigurable(RssConf conf, ConfigOption<T> option) {
            this.conf = conf;
            this.option = option;
        }

        @Override
        public T get() {
            return this.conf.get(this.option);
        }

        @Override
        public long getSizeAsBytes() {
            return this.conf.getSizeAsBytes(this.option);
        }
    }
}

