/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.metrics.RPCMetrics;

public abstract class NettyMetrics
extends RPCMetrics {
    private static final String NETTY_ACTIVE_CONNECTION = "netty_active_connection";
    private static final String NETTY_HANDLE_EXCEPTION = "netty_handle_exception";
    private static final String NETTY_PENDING_TASKS_NUM_FOR_BOSS_GROUP = "netty_pending_tasks_num_for_boss_group";
    private static final String NETTY_PENDING_TASKS_NUM_FOR_WORKER_GROUP = "netty_pending_tasks_num_for_worker_group";
    protected Gauge.Child gaugeNettyActiveConn;
    protected Counter.Child counterNettyException;
    protected Gauge.Child gaugeNettyPendingTasksNumForBossGroup;
    protected Gauge.Child gaugeNettyPendingTasksNumForWorkerGroup;

    public NettyMetrics(RssConf rssConf, String tags) {
        super(rssConf, tags);
    }

    @Override
    public void registerGeneralMetrics() {
        this.gaugeNettyActiveConn = this.metricsManager.addLabeledGauge(NETTY_ACTIVE_CONNECTION);
        this.counterNettyException = this.metricsManager.addLabeledCounter(NETTY_HANDLE_EXCEPTION);
        this.gaugeNettyPendingTasksNumForBossGroup = this.metricsManager.addLabeledGauge(NETTY_PENDING_TASKS_NUM_FOR_BOSS_GROUP);
        this.gaugeNettyPendingTasksNumForWorkerGroup = this.metricsManager.addLabeledGauge(NETTY_PENDING_TASKS_NUM_FOR_WORKER_GROUP);
    }

    public Counter.Child getCounterNettyException() {
        return this.counterNettyException;
    }

    public Gauge.Child getGaugeNettyActiveConn() {
        return this.gaugeNettyActiveConn;
    }

    public Gauge.Child getGaugeNettyPendingTasksNumForBossGroup() {
        return this.gaugeNettyPendingTasksNumForBossGroup;
    }

    public Gauge.Child getGaugeNettyPendingTasksNumForWorkerGroup() {
        return this.gaugeNettyPendingTasksNumForWorkerGroup;
    }
}

