/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.apache.uniffle.common.serializer.SerInputStream;

public class BufferSerInputStream
extends SerInputStream {
    private ByteBuf buffer;
    private final int start;
    private final int end;
    private final int size;

    public BufferSerInputStream(ByteBuf byteBuf, int start, int end) {
        assert (start >= 0);
        this.buffer = byteBuf;
        this.start = start;
        this.end = end;
        this.buffer.readerIndex(start);
        this.size = end - start;
    }

    @Override
    public int available() {
        return this.end - this.buffer.readerIndex();
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public void transferTo(ByteBuf to, int len) throws IOException {
        to.writeBytes(this.buffer, len);
    }

    @Override
    public int read() throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }
}

