/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.writable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.serializer.DeserializationStream;
import org.apache.uniffle.common.serializer.SerInputStream;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.serializer.SerializationStream;
import org.apache.uniffle.common.serializer.SerializerInstance;
import org.apache.uniffle.common.serializer.writable.BufferedRawWritableDeserializationStream;
import org.apache.uniffle.common.serializer.writable.BufferedRawWritableSerializationStream;
import org.apache.uniffle.common.serializer.writable.RawWritableDeserializationStream;
import org.apache.uniffle.common.serializer.writable.RawWritableSerializationStream;
import org.apache.uniffle.common.serializer.writable.WritableDeserializationStream;
import org.apache.uniffle.common.serializer.writable.WritableSerializationStream;

public class WritableSerializerInstance
extends SerializerInstance {
    public WritableSerializerInstance(RssConf rssConf) {
    }

    @Override
    public <T> void serialize(T t, DataOutputStream out) throws IOException {
        ((Writable)t).write((DataOutput)out);
    }

    @Override
    public <T> T deserialize(DataInputBuffer buffer, Class vClass) throws IOException {
        Writable writable = (Writable)ReflectionUtils.newInstance((Class)vClass, null);
        writable.readFields((DataInput)buffer);
        return (T)writable;
    }

    @Override
    public <K, V> SerializationStream serializeStream(SerOutputStream output, boolean raw, boolean buffered) {
        if (raw) {
            if (buffered) {
                return new BufferedRawWritableSerializationStream(this, output);
            }
            return new RawWritableSerializationStream(this, output);
        }
        return new WritableSerializationStream(this, output);
    }

    @Override
    public <K, V> DeserializationStream deserializeStream(SerInputStream input, Class<K> keyClass, Class<V> valueClass, boolean raw, boolean buffered) {
        if (raw) {
            if (buffered) {
                return new BufferedRawWritableDeserializationStream(this, input);
            }
            return new RawWritableDeserializationStream(this, input);
        }
        return new WritableDeserializationStream<K, V>(this, input, keyClass, valueClass);
    }
}

