/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.reader;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Aggregator;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.ShuffleReadMetrics;
import org.apache.spark.executor.TempShuffleReadMetrics;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.RssShuffleHandle;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.reader.RssFetchFailedIterator;
import org.apache.spark.shuffle.reader.RssShuffleDataIterator;
import org.apache.spark.util.CompletionIterator;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.TaskCompletionListener;
import org.apache.spark.util.collection.ExternalSorter;
import org.apache.uniffle.client.api.ShuffleManagerClient;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product2;
import scala.collection.Iterator;
import scala.runtime.AbstractFunction0;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;

public class RssShuffleReader<K, C>
implements ShuffleReader<K, C> {
    private static final Logger LOG = LoggerFactory.getLogger(RssShuffleReader.class);
    private final boolean expectedTaskIdsBitmapFilterEnable;
    private String appId;
    private int shuffleId;
    private int startPartition;
    private int endPartition;
    private TaskContext context;
    private ShuffleDependency<K, C, ?> shuffleDependency;
    private Serializer serializer;
    private String taskId;
    private String basePath;
    private int partitionNumPerRange;
    private int partitionNum;
    private Roaring64NavigableMap blockIdBitmap;
    private Roaring64NavigableMap taskIdBitmap;
    private List<ShuffleServerInfo> shuffleServerInfoList;
    private Configuration hadoopConf;
    private RssConf rssConf;
    private Supplier<ShuffleManagerClient> managerClientSupplier;

    public RssShuffleReader(int startPartition, int endPartition, TaskContext context, RssShuffleHandle<K, C, ?> rssShuffleHandle, String basePath, Configuration hadoopConf, int partitionNumPerRange, int partitionNum, Roaring64NavigableMap blockIdBitmap, Roaring64NavigableMap taskIdBitmap, RssConf rssConf, Map<Integer, List<ShuffleServerInfo>> partitionToServers, Supplier<ShuffleManagerClient> managerClientSupplier) {
        this.appId = rssShuffleHandle.getAppId();
        this.startPartition = startPartition;
        this.endPartition = endPartition;
        this.context = context;
        this.shuffleDependency = rssShuffleHandle.getDependency();
        this.shuffleId = this.shuffleDependency.shuffleId();
        this.serializer = rssShuffleHandle.getDependency().serializer();
        this.taskId = "" + context.taskAttemptId() + "_" + context.attemptNumber();
        this.basePath = basePath;
        this.partitionNumPerRange = partitionNumPerRange;
        this.partitionNum = partitionNum;
        this.blockIdBitmap = blockIdBitmap;
        this.taskIdBitmap = taskIdBitmap;
        this.hadoopConf = hadoopConf;
        this.shuffleServerInfoList = partitionToServers.get(startPartition);
        this.rssConf = rssConf;
        this.managerClientSupplier = managerClientSupplier;
        this.expectedTaskIdsBitmapFilterEnable = this.shuffleServerInfoList.size() > 1;
    }

    public Iterator<Product2<K, C>> read() {
        Object resultIter;
        LOG.info("Shuffle read started:" + this.getReadInfo());
        int retryMax = this.rssConf.getInteger("rss.client.retry.max", 50);
        long retryIntervalMax = this.rssConf.getLong("rss.client.retry.interval.max", 10000L);
        ShuffleReadClient shuffleReadClient = ShuffleClientFactory.getInstance().createShuffleReadClient(ShuffleClientFactory.newReadBuilder().appId(this.appId).shuffleId(this.shuffleId).partitionId(this.startPartition).basePath(this.basePath).partitionNumPerRange(this.partitionNumPerRange).partitionNum(this.partitionNum).blockIdBitmap(this.blockIdBitmap).taskIdBitmap(this.taskIdBitmap).shuffleServerInfoList(this.shuffleServerInfoList).hadoopConf(this.hadoopConf).expectedTaskIdsBitmapFilterEnable(this.expectedTaskIdsBitmapFilterEnable).retryMax(retryMax).retryIntervalMax(retryIntervalMax).rssConf(this.rssConf));
        final InterruptibleIterator rssShuffleDataIterator = new RssShuffleDataIterator(this.shuffleDependency.serializer(), shuffleReadClient, new ReadMetrics(this.context.taskMetrics().createTempShuffleReadMetrics()), this.rssConf);
        CompletionIterator completionIterator = CompletionIterator$.MODULE$.apply(rssShuffleDataIterator, (Function0)new AbstractFunction0<BoxedUnit>(){

            public BoxedUnit apply() {
                RssShuffleReader.this.context.taskMetrics().mergeShuffleReadMetrics();
                return rssShuffleDataIterator.cleanup();
            }
        });
        this.context.addTaskCompletionListener(context -> completionIterator.completion());
        if (this.shuffleDependency.keyOrdering().isDefined()) {
            Option aggregator = Option.empty();
            if (this.shuffleDependency.aggregator().isDefined()) {
                aggregator = this.shuffleDependency.mapSideCombine() ? Option.apply((Object)new Aggregator((Function1)new AbstractFunction1<C, C>(){

                    public C apply(C x) {
                        return x;
                    }
                }, ((Aggregator)this.shuffleDependency.aggregator().get()).mergeCombiners(), ((Aggregator)this.shuffleDependency.aggregator().get()).mergeCombiners())) : Option.apply((Object)((Aggregator)this.shuffleDependency.aggregator().get()));
            }
            final ExternalSorter sorter = new ExternalSorter(this.context, aggregator, Option.empty(), this.shuffleDependency.keyOrdering(), this.serializer);
            LOG.info("Inserting aggregated records to sorter");
            long startTime = System.currentTimeMillis();
            sorter.insertAll((Iterator)rssShuffleDataIterator);
            LOG.info("Inserted aggregated records to sorter: millis:" + (System.currentTimeMillis() - startTime));
            this.context.taskMetrics().incMemoryBytesSpilled(sorter.memoryBytesSpilled());
            this.context.taskMetrics().incDiskBytesSpilled(sorter.diskBytesSpilled());
            this.context.taskMetrics().incPeakExecutionMemory(sorter.peakMemoryUsedBytes());
            this.context.addTaskCompletionListener(new TaskCompletionListener(){

                public void onTaskCompletion(TaskContext context) {
                    sorter.stop();
                }
            });
            AbstractFunction0<BoxedUnit> fn0 = new AbstractFunction0<BoxedUnit>(){

                public BoxedUnit apply() {
                    sorter.stop();
                    return BoxedUnit.UNIT;
                }
            };
            resultIter = CompletionIterator$.MODULE$.apply(sorter.iterator(), (Function0)fn0);
        } else if (this.shuffleDependency.aggregator().isDefined()) {
            Aggregator aggregator = (Aggregator)this.shuffleDependency.aggregator().get();
            resultIter = this.shuffleDependency.mapSideCombine() ? aggregator.combineCombinersByKey((Iterator)rssShuffleDataIterator, this.context) : aggregator.combineValuesByKey((Iterator)rssShuffleDataIterator, this.context);
        } else {
            resultIter = rssShuffleDataIterator;
        }
        if (!(resultIter instanceof InterruptibleIterator)) {
            resultIter = new InterruptibleIterator(this.context, resultIter);
        }
        if (this.rssConf.getBoolean(RssSparkConfig.RSS_RESUBMIT_STAGE_WITH_FETCH_FAILURE_ENABLED) && this.rssConf.getInteger(RssClientConf.SHUFFLE_MANAGER_GRPC_PORT, 0) > 0) {
            resultIter = RssFetchFailedIterator.newBuilder().appId(this.appId).shuffleId(this.shuffleId).partitionId(this.startPartition).stageAttemptId(this.context.stageAttemptNumber()).managerClientSupplier(this.managerClientSupplier).build(resultIter);
        }
        return resultIter;
    }

    private String getReadInfo() {
        return "appId=" + this.appId + ", shuffleId=" + this.shuffleId + ",taskId=" + this.taskId + ", partitions: [" + this.startPartition + ", " + this.endPartition + ")";
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    static class ReadMetrics
    extends ShuffleReadMetrics {
        private TempShuffleReadMetrics tempShuffleReadMetrics;

        ReadMetrics(TempShuffleReadMetrics tempShuffleReadMetric) {
            this.tempShuffleReadMetrics = tempShuffleReadMetric;
        }

        public void incRemoteBytesRead(long v) {
            this.tempShuffleReadMetrics.incRemoteBytesRead(v);
        }

        public void incFetchWaitTime(long v) {
            this.tempShuffleReadMetrics.incFetchWaitTime(v);
        }

        public void incRecordsRead(long v) {
            this.tempShuffleReadMetrics.incRecordsRead(v);
        }
    }
}

