/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.uniffle.common.ShuffleDataSegment;

public class ReadSegment {
    private final long offset;
    private final long length;

    public ReadSegment(long offset, long length) {
        this.offset = offset;
        this.length = length;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public static ReadSegment from(ShuffleDataSegment segment) {
        return new ReadSegment(segment.getOffset(), segment.getLength());
    }

    public static List<ReadSegment> from(List<ShuffleDataSegment> segments) {
        ArrayList<ReadSegment> readSegments = new ArrayList<ReadSegment>();
        for (ShuffleDataSegment segment : segments) {
            readSegments.add(ReadSegment.from(segment));
        }
        return readSegments;
    }
}

