/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import org.apache.uniffle.common.netty.protocol.GetLocalShuffleDataRequest;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.shaded.io.netty.buffer.ByteBuf;

public class GetLocalShuffleDataV2Request
extends GetLocalShuffleDataRequest {
    public GetLocalShuffleDataV2Request(long requestId, String appId, int shuffleId, int partitionId, int partitionNumPerRange, int partitionNum, long offset, int length, int storageId, long timestamp) {
        super(requestId, appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, offset, length, storageId, timestamp);
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_LOCAL_SHUFFLE_DATA_V2_REQUEST;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + 4;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        buf.writeInt(this.getStorageId());
    }

    public static GetLocalShuffleDataV2Request decode(ByteBuf byteBuf) {
        long requestId = byteBuf.readLong();
        String appId = ByteBufUtils.readLengthAndString(byteBuf);
        int shuffleId = byteBuf.readInt();
        int partitionId = byteBuf.readInt();
        int partitionNumPerRange = byteBuf.readInt();
        int partitionNum = byteBuf.readInt();
        long offset = byteBuf.readLong();
        int length = byteBuf.readInt();
        long timestamp = byteBuf.readLong();
        int storageId = byteBuf.readInt();
        return new GetLocalShuffleDataV2Request(requestId, appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, offset, length, storageId, timestamp);
    }

    @Override
    public String getOperationType() {
        return "getLocalShuffleDataV2";
    }
}

