/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleDataSegment;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.segment.SegmentSplitterFactory;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.storage.handler.impl.PrefetchableClientReadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSkippableReadHandler
extends PrefetchableClientReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DataSkippableReadHandler.class);
    private static final int DEFAULT_NEXT_READ_BATCH_NUMBER = 4;
    protected List<ShuffleDataSegment> shuffleDataSegments = Lists.newArrayList();
    protected int segmentIndex = 0;
    protected Roaring64NavigableMap expectBlockIds;
    protected Set<Long> processBlockIds;
    protected ShuffleDataDistributionType distributionType;
    protected Roaring64NavigableMap expectTaskIds;
    private int nextReadSegmentReportCount;

    public DataSkippableReadHandler(String appId, int shuffleId, int partitionId, int readBufferSize, Roaring64NavigableMap expectBlockIds, Set<Long> processBlockIds, ShuffleDataDistributionType distributionType, Roaring64NavigableMap expectTaskIds, Optional<PrefetchableClientReadHandler.PrefetchOption> prefetchOption, int nextReadSegmentReportCount) {
        super(prefetchOption);
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.readBufferSize = readBufferSize;
        this.expectBlockIds = expectBlockIds;
        this.processBlockIds = processBlockIds;
        this.distributionType = distributionType;
        this.expectTaskIds = expectTaskIds;
        this.nextReadSegmentReportCount = nextReadSegmentReportCount;
    }

    protected abstract ShuffleIndexResult readShuffleIndex();

    protected abstract ShuffleDataResult readShuffleData(ShuffleDataSegment var1, List<ShuffleDataSegment> var2);

    @Override
    public ShuffleDataResult doReadShuffleData() {
        if (this.shuffleDataSegments.isEmpty()) {
            ShuffleIndexResult shuffleIndexResult = this.readShuffleIndex();
            if (shuffleIndexResult == null || shuffleIndexResult.isEmpty()) {
                return null;
            }
            try {
                this.shuffleDataSegments = SegmentSplitterFactory.getInstance().get(this.distributionType, this.expectTaskIds, this.readBufferSize).split(shuffleIndexResult);
            }
            finally {
                shuffleIndexResult.release();
            }
        }
        ShuffleDataResult result = null;
        while (this.segmentIndex < this.shuffleDataSegments.size()) {
            ShuffleDataSegment segment = this.shuffleDataSegments.get(this.segmentIndex);
            HashSet<Long> blocksOfSegment = new HashSet<Long>();
            segment.getBufferSegments().forEach(block -> blocksOfSegment.add(block.getBlockId()));
            blocksOfSegment.removeIf(blockId -> !this.expectBlockIds.contains((long)blockId));
            if (!blocksOfSegment.isEmpty()) {
                blocksOfSegment.removeAll(this.processBlockIds);
                if (!blocksOfSegment.isEmpty()) {
                    result = this.readShuffleData(segment, DataSkippableReadHandler.getNextSegments(this.shuffleDataSegments, this.segmentIndex + 1, this.nextReadSegmentReportCount));
                    ++this.segmentIndex;
                    break;
                }
            }
            ++this.segmentIndex;
        }
        return result;
    }

    @VisibleForTesting
    protected static List<ShuffleDataSegment> getNextSegments(List<ShuffleDataSegment> shuffleDataSegments, int startIndex, int number) {
        ArrayList<ShuffleDataSegment> nextSegments = Lists.newArrayList();
        for (int i = startIndex; i < shuffleDataSegments.size() && nextSegments.size() < number; ++i) {
            nextSegments.add(shuffleDataSegments.get(i));
        }
        return nextSegments;
    }
}

