/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.apache.uniffle.storage.handler.AsynDeletionEvent;
import org.apache.uniffle.storage.handler.api.ShuffleDeleteHandler;
import org.apache.uniffle.storage.handler.impl.AsynDeletionEventManager;
import org.apache.uniffle.storage.util.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileAsyncDeleteHandler
implements ShuffleDeleteHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileAsyncDeleteHandler.class);
    private AsynDeletionEventManager asynDeletionEventManager;

    public LocalFileAsyncDeleteHandler(AsynDeletionEventManager asynDeletionEventManager) {
        this.asynDeletionEventManager = asynDeletionEventManager;
    }

    @Override
    public boolean delete(String[] storageBasePaths, String appId, String user) {
        AsynDeletionEvent asynDeletionEvent = new AsynDeletionEvent(appId, user, null, null, Arrays.asList(storageBasePaths), StorageType.LOCALFILE.name());
        for (Map.Entry<String, String> appIdNeedDeletePaths : asynDeletionEvent.getNeedDeletePathAndRenamePath().entrySet()) {
            String shufflePath = appIdNeedDeletePaths.getKey();
            String breakdownShufflePath = appIdNeedDeletePaths.getValue();
            boolean isSuccess = false;
            long start = System.currentTimeMillis();
            try {
                File baseFolder = new File(shufflePath);
                boolean isExists = baseFolder.exists();
                File breakdownBaseFolder = new File(breakdownShufflePath);
                if (isExists) {
                    isSuccess = baseFolder.renameTo(breakdownBaseFolder);
                }
                if (isExists) {
                    if (isSuccess) {
                        LOG.info("Rename shuffle data for appId[{}] with {} to {} cost {} ms", new Object[]{appId, shufflePath, breakdownShufflePath, System.currentTimeMillis() - start});
                        continue;
                    }
                    LOG.warn("Can't Rename shuffle data for appId[{}] with {} to {}", new Object[]{appId, shufflePath, breakdownShufflePath});
                    continue;
                }
                LOG.info("Rename shuffle data for appId[{}],[{}] is not exists", (Object)appId, (Object)shufflePath);
            }
            catch (Exception e) {
                LOG.error("Can't Rename shuffle data for appId[{}] with {} to {}", new Object[]{appId, shufflePath, breakdownShufflePath, e});
            }
        }
        if (!this.asynDeletionEventManager.handlerAsynDelete(asynDeletionEvent)) {
            LOG.warn("Remove the case where the renameAndDeletionEventQueue queue is full and cannot accept elements.");
            return false;
        }
        return true;
    }
}

