/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.ReconfigurableRegistry;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.StorageType;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.exception.ExceedHugePartitionHardLimitException;
import org.apache.uniffle.common.exception.FileNotFoundException;
import org.apache.uniffle.common.exception.NoBufferException;
import org.apache.uniffle.common.exception.NoBufferForHugePartitionException;
import org.apache.uniffle.common.exception.NoRegisterException;
import org.apache.uniffle.common.merger.MergeState;
import org.apache.uniffle.common.rpc.ClientContextServerInterceptor;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.BlockIdLayout;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.common.util.OutputUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.proto.ShuffleServerGrpc;
import org.apache.uniffle.server.ShuffleDataReadEvent;
import org.apache.uniffle.server.ShuffleServer;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleTaskInfo;
import org.apache.uniffle.server.ShuffleTaskManager;
import org.apache.uniffle.server.audit.ServerRpcAuditContext;
import org.apache.uniffle.server.buffer.PreAllocatedBufferInfo;
import org.apache.uniffle.server.merge.MergeStatus;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.apache.uniffle.shaded.guava.collect.Maps;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.common.StorageReadMetrics;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerGrpcService
extends ShuffleServerGrpc.ShuffleServerImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleServerGrpcService.class);
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"SHUFFLE_SERVER_RPC_AUDIT_LOG");
    private final ShuffleServer shuffleServer;
    private boolean isRpcAuditLogEnabled;
    private List<String> rpcAuditExcludeOpList;
    private boolean reportOnUnregisterEnabled;

    public ShuffleServerGrpcService(ShuffleServer shuffleServer) {
        this.shuffleServer = shuffleServer;
        this.isRpcAuditLogEnabled = (Boolean)shuffleServer.getShuffleServerConf().getReconfigurableConf(ShuffleServerConf.SERVER_RPC_AUDIT_LOG_ENABLED).get();
        this.rpcAuditExcludeOpList = (List)shuffleServer.getShuffleServerConf().getReconfigurableConf(ShuffleServerConf.SERVER_RPC_RPC_AUDIT_LOG_EXCLUDE_LIST).get();
        this.reportOnUnregisterEnabled = shuffleServer.getShuffleServerConf().getBoolean(ShuffleServerConf.SERVER_HEARTBEAT_REPORT_ON_UNREGISTER_ENABLED);
        ReconfigurableRegistry.register(Sets.newHashSet(ShuffleServerConf.SERVER_RPC_AUDIT_LOG_ENABLED.key(), ShuffleServerConf.SERVER_RPC_RPC_AUDIT_LOG_EXCLUDE_LIST.key()), (conf, changedProperties) -> {
            if (changedProperties == null) {
                return;
            }
            if (changedProperties.contains(ShuffleServerConf.SERVER_RPC_AUDIT_LOG_ENABLED.key())) {
                this.isRpcAuditLogEnabled = conf.getBoolean(ShuffleServerConf.SERVER_RPC_AUDIT_LOG_ENABLED);
            }
            if (changedProperties.contains(ShuffleServerConf.SERVER_RPC_RPC_AUDIT_LOG_EXCLUDE_LIST.key())) {
                this.rpcAuditExcludeOpList = (List)conf.get(ShuffleServerConf.SERVER_RPC_RPC_AUDIT_LOG_EXCLUDE_LIST);
            }
        });
    }

    public void unregisterShuffleByAppId(RssProtos.ShuffleUnregisterByAppIdRequest request, StreamObserver<RssProtos.ShuffleUnregisterByAppIdResponse> responseStreamObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("unregisterShuffleByAppId");){
            String appId = request.getAppId();
            auditContext.withAppId(appId);
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.ShuffleUnregisterByAppIdResponse reply = RssProtos.ShuffleUnregisterByAppIdResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseStreamObserver.onNext((Object)reply);
                responseStreamObserver.onCompleted();
                return;
            }
            String responseMessage = "OK";
            try {
                if (this.reportOnUnregisterEnabled) {
                    this.shuffleServer.sendHeartbeat();
                }
                this.shuffleServer.getShuffleTaskManager().removeShuffleDataAsync(appId);
                if (this.shuffleServer.isRemoteMergeEnable()) {
                    this.shuffleServer.getShuffleTaskManager().removeShuffleDataAsync(appId + "@RemoteMerge");
                }
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                LOG.error("App {} exception while unregisterShuffleByAppId", (Object)appId, (Object)e);
            }
            auditContext.withStatusCode(status);
            RssProtos.ShuffleUnregisterByAppIdResponse reply = RssProtos.ShuffleUnregisterByAppIdResponse.newBuilder().setStatus(status.toProto()).setRetMsg(responseMessage).build();
            responseStreamObserver.onNext((Object)reply);
            responseStreamObserver.onCompleted();
        }
    }

    public void unregisterShuffle(RssProtos.ShuffleUnregisterRequest request, StreamObserver<RssProtos.ShuffleUnregisterResponse> responseStreamObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("unregisterShuffle");){
            String appId = request.getAppId();
            int shuffleId = request.getShuffleId();
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.ShuffleUnregisterResponse reply = RssProtos.ShuffleUnregisterResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseStreamObserver.onNext((Object)reply);
                responseStreamObserver.onCompleted();
                return;
            }
            String responseMessage = "OK";
            try {
                if (this.reportOnUnregisterEnabled) {
                    this.shuffleServer.sendHeartbeat();
                }
                this.shuffleServer.getShuffleTaskManager().removeShuffleDataAsync(appId, shuffleId);
                if (this.shuffleServer.isRemoteMergeEnable()) {
                    this.shuffleServer.getShuffleTaskManager().removeShuffleDataAsync(appId + "@RemoteMerge", shuffleId);
                }
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                LOG.error("App {} exception while unregisterShuffle", (Object)appId, (Object)e);
            }
            auditContext.withStatusCode(status);
            RssProtos.ShuffleUnregisterResponse reply = RssProtos.ShuffleUnregisterResponse.newBuilder().setStatus(status.toProto()).setRetMsg(responseMessage).build();
            responseStreamObserver.onNext((Object)reply);
            responseStreamObserver.onCompleted();
        }
    }

    public void registerShuffle(RssProtos.ShuffleRegisterRequest req, StreamObserver<RssProtos.ShuffleRegisterResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("registerShuffle");){
            String appId = req.getAppId();
            int shuffleId = req.getShuffleId();
            String remoteStoragePath = req.getRemoteStorage().getPath();
            String user = req.getUser();
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            auditContext.withArgs("remoteStoragePath=" + remoteStoragePath + ", user=" + user);
            ShuffleDataDistributionType shuffleDataDistributionType = ShuffleDataDistributionType.valueOf((String)Optional.ofNullable(req.getShuffleDataDistribution()).orElse(RssProtos.DataDistribution.NORMAL).name());
            int maxConcurrencyPerPartitionToWrite = req.getMaxConcurrencyPerPartitionToWrite();
            Map<String, String> remoteStorageConf = req.getRemoteStorage().getRemoteStorageConfList().stream().collect(Collectors.toMap(RssProtos.RemoteStorageConfItem::getKey, RssProtos.RemoteStorageConfItem::getValue));
            List<PartitionRange> partitionRanges = this.toPartitionRanges(req.getPartitionRangesList());
            LOG.info("Get register request for appId[{}], shuffleId[{}], remoteStorage[{}] with {} partition ranges. User: {}", new Object[]{appId, shuffleId, remoteStoragePath, partitionRanges.size(), user});
            StatusCode result = this.shuffleServer.getShuffleTaskManager().registerShuffle(appId, shuffleId, partitionRanges, new RemoteStorageInfo(remoteStoragePath, remoteStorageConf), user, shuffleDataDistributionType, maxConcurrencyPerPartitionToWrite, req.getPropertiesMap());
            if (StatusCode.SUCCESS == result && this.shuffleServer.isRemoteMergeEnable() && req.hasMergeContext() && (result = this.shuffleServer.getShuffleTaskManager().registerShuffle(appId + "@RemoteMerge", shuffleId, partitionRanges, new RemoteStorageInfo(remoteStoragePath, remoteStorageConf), user, shuffleDataDistributionType, maxConcurrencyPerPartitionToWrite, req.getPropertiesMap())) == StatusCode.SUCCESS) {
                result = this.shuffleServer.getShuffleMergeManager().registerShuffle(appId, shuffleId, req.getMergeContext());
            }
            auditContext.withStatusCode(result);
            RssProtos.ShuffleRegisterResponse reply = RssProtos.ShuffleRegisterResponse.newBuilder().setStatus(result.toProto()).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendShuffleData(RssProtos.SendShuffleDataRequest req, StreamObserver<RssProtos.SendShuffleDataResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("sendShuffleData");){
            RssProtos.SendShuffleDataResponse reply;
            long transportTime;
            String appId = req.getAppId();
            int shuffleId = req.getShuffleId();
            long requireBufferId = req.getRequireBufferId();
            long timestamp = req.getTimestamp();
            int stageAttemptNumber = req.getStageAttemptNumber();
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            auditContext.withArgs("requireBufferId=" + requireBufferId + ", timestamp=" + timestamp + ", stageAttemptNumber=" + stageAttemptNumber + ", shuffleDataSize=" + req.getShuffleDataCount());
            ShuffleTaskInfo taskInfo = this.shuffleServer.getShuffleTaskManager().getShuffleTaskInfo(appId);
            if (taskInfo == null) {
                String errorMsg = "APP_NOT_FOUND error, requireBufferId[" + requireBufferId + "] for appId[" + appId + "], shuffleId[" + shuffleId + "]";
                LOG.error(errorMsg);
                ShuffleServerMetrics.counterAppNotFound.inc();
                RssProtos.SendShuffleDataResponse reply2 = RssProtos.SendShuffleDataResponse.newBuilder().setStatus(StatusCode.APP_NOT_FOUND.toProto()).setRetMsg(errorMsg).build();
                auditContext.withStatusCode(StatusCode.fromProto((RssProtos.StatusCode)reply2.getStatus()));
                responseObserver.onNext((Object)reply2);
                responseObserver.onCompleted();
                return;
            }
            Integer latestStageAttemptNumber = taskInfo.getLatestStageAttemptNumber(shuffleId);
            if (stageAttemptNumber < latestStageAttemptNumber) {
                String responseMessage = "A retry has occurred at the Stage, sending data is invalid.";
                RssProtos.SendShuffleDataResponse reply3 = RssProtos.SendShuffleDataResponse.newBuilder().setStatus(StatusCode.STAGE_RETRY_IGNORE.toProto()).setRetMsg(responseMessage).build();
                auditContext.withStatusCode(StatusCode.fromProto((RssProtos.StatusCode)reply3.getStatus()));
                responseObserver.onNext((Object)reply3);
                responseObserver.onCompleted();
                return;
            }
            if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
                this.shuffleServer.getGrpcMetrics().recordTransportTime("sendShuffleData", transportTime);
            }
            int requireSize = this.shuffleServer.getShuffleTaskManager().getRequireBufferSize(requireBufferId);
            StatusCode ret = StatusCode.SUCCESS;
            String responseMessage = "OK";
            if (req.getShuffleDataCount() > 0) {
                boolean isPreAllocated;
                ShuffleServerMetrics.counterTotalReceivedDataSize.inc((double)requireSize);
                ShuffleTaskManager manager = this.shuffleServer.getShuffleTaskManager();
                PreAllocatedBufferInfo info = manager.getAndRemovePreAllocatedBuffer(requireBufferId);
                boolean bl = isPreAllocated = info != null;
                if (!isPreAllocated) {
                    String errorMsg = "Can't find requireBufferId[" + requireBufferId + "] for appId[" + appId + "], shuffleId[" + shuffleId + "]";
                    LOG.warn(errorMsg);
                    responseMessage = errorMsg;
                    RssProtos.SendShuffleDataResponse reply4 = RssProtos.SendShuffleDataResponse.newBuilder().setStatus(StatusCode.INTERNAL_ERROR.toProto()).setRetMsg(responseMessage).build();
                    auditContext.withStatusCode(StatusCode.fromProto((RssProtos.StatusCode)reply4.getStatus()));
                    responseObserver.onNext((Object)reply4);
                    responseObserver.onCompleted();
                    return;
                }
                long start = System.currentTimeMillis();
                List<ShufflePartitionedData> shufflePartitionedDataList = this.toPartitionedDataList(req);
                long alreadyReleasedSize = 0L;
                boolean hasFailureOccurred = false;
                for (ShufflePartitionedData spd : shufflePartitionedDataList) {
                    String errorMsg;
                    String shuffleDataInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + spd.getPartitionId() + "]";
                    try {
                        ret = manager.cacheShuffleData(appId, shuffleId, isPreAllocated, spd);
                        if (ret != StatusCode.SUCCESS) {
                            String errorMsg2 = "Error happened when shuffleEngine.write for " + shuffleDataInfo + ", statusCode=" + ret;
                            LOG.error(errorMsg2);
                            responseMessage = errorMsg2;
                            hasFailureOccurred = true;
                            break;
                        }
                        if (this.shuffleServer.isRemoteMergeEnable()) {
                            this.shuffleServer.getShuffleMergeManager().setDirect(appId, shuffleId, false);
                        }
                        long toReleasedSize = spd.getTotalBlockEncodedLength();
                        manager.releasePreAllocatedSize(toReleasedSize);
                        alreadyReleasedSize += toReleasedSize;
                        manager.updateCachedBlockIds(appId, shuffleId, spd.getPartitionId(), spd.getBlockList());
                    }
                    catch (ExceedHugePartitionHardLimitException e) {
                        errorMsg = "ExceedHugePartitionHardLimitException Error happened when shuffleEngine.write for " + shuffleDataInfo + ": " + e.getMessage();
                        ShuffleServerMetrics.counterTotalHugePartitionExceedHardLimitNum.inc();
                        ret = StatusCode.EXCEED_HUGE_PARTITION_HARD_LIMIT;
                        responseMessage = errorMsg;
                        LOG.error(errorMsg);
                        hasFailureOccurred = true;
                    }
                    catch (Exception e) {
                        errorMsg = "Error happened when shuffleEngine.write for " + shuffleDataInfo + ": " + e.getMessage();
                        ret = StatusCode.INTERNAL_ERROR;
                        responseMessage = errorMsg;
                        LOG.error(errorMsg, (Throwable)e);
                        hasFailureOccurred = true;
                        break;
                    }
                    finally {
                        if (!hasFailureOccurred) continue;
                        this.shuffleServer.getShuffleBufferManager().releaseMemory(spd.getTotalBlockEncodedLength(), false, false);
                    }
                }
                if ((long)info.getRequireSize() > alreadyReleasedSize) {
                    manager.releasePreAllocatedSize((long)info.getRequireSize() - alreadyReleasedSize);
                }
                reply = RssProtos.SendShuffleDataResponse.newBuilder().setStatus(ret.toProto()).setRetMsg(responseMessage).build();
                long costTime = System.currentTimeMillis() - start;
                this.shuffleServer.getGrpcMetrics().recordProcessTime("sendShuffleData", costTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cache Shuffle Data for appId[" + appId + "], shuffleId[" + shuffleId + "], cost " + costTime + " ms with " + shufflePartitionedDataList.size() + " blocks and " + requireSize + " bytes");
                }
            } else {
                reply = RssProtos.SendShuffleDataResponse.newBuilder().setStatus(StatusCode.INTERNAL_ERROR.toProto()).setRetMsg("No data in request").build();
            }
            auditContext.withStatusCode(StatusCode.fromProto((RssProtos.StatusCode)reply.getStatus()));
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    public void commitShuffleTask(RssProtos.ShuffleCommitRequest req, StreamObserver<RssProtos.ShuffleCommitResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("commitShuffleTask");){
            String appId = req.getAppId();
            int shuffleId = req.getShuffleId();
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            StorageType storageType = (StorageType)this.shuffleServer.getShuffleServerConf().get(ShuffleServerConf.RSS_STORAGE_TYPE);
            boolean storageTypeWithMemory = org.apache.uniffle.storage.util.StorageType.withMemory((org.apache.uniffle.storage.util.StorageType)org.apache.uniffle.storage.util.StorageType.valueOf((String)storageType.name()));
            if (storageTypeWithMemory) {
                String errorMessage = String.format("commitShuffleTask should not be called while server-side configured StorageType to %s for appId %s", storageType, appId);
                LOG.error(errorMessage);
                throw new UnsupportedOperationException(errorMessage);
            }
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.ShuffleCommitResponse response = RssProtos.ShuffleCommitResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
                return;
            }
            String msg = "OK";
            int commitCount = 0;
            try {
                if (!this.shuffleServer.getShuffleTaskManager().getAppIds().contains(appId)) {
                    throw new IllegalStateException("AppId " + appId + " was removed already");
                }
                commitCount = this.shuffleServer.getShuffleTaskManager().updateAndGetCommitCount(appId, shuffleId);
                auditContext.withReturnValue("commitCount=" + commitCount);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Get commitShuffleTask request for appId[" + appId + "], shuffleId[" + shuffleId + "], currentCommitted[" + commitCount + "]");
                }
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                msg = "Error happened when commit for appId[" + appId + "], shuffleId[" + shuffleId + "]";
                LOG.error(msg, (Throwable)e);
            }
            auditContext.withStatusCode(status);
            RssProtos.ShuffleCommitResponse reply = RssProtos.ShuffleCommitResponse.newBuilder().setCommitCount(commitCount).setStatus(status.toProto()).setRetMsg(msg).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    public void finishShuffle(RssProtos.FinishShuffleRequest req, StreamObserver<RssProtos.FinishShuffleResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("finishShuffle");){
            String appId = req.getAppId();
            int shuffleId = req.getShuffleId();
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            StorageType storageType = (StorageType)this.shuffleServer.getShuffleServerConf().get(ShuffleServerConf.RSS_STORAGE_TYPE);
            boolean storageTypeWithMemory = org.apache.uniffle.storage.util.StorageType.withMemory((org.apache.uniffle.storage.util.StorageType)org.apache.uniffle.storage.util.StorageType.valueOf((String)storageType.name()));
            if (storageTypeWithMemory) {
                String errorMessage = String.format("finishShuffle should not be called while server-side configured StorageType to %s for appId %s", storageType, appId);
                LOG.error(errorMessage);
                throw new UnsupportedOperationException(errorMessage);
            }
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.FinishShuffleResponse response = RssProtos.FinishShuffleResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
                return;
            }
            String msg = "OK";
            String errorMsg = "Fail to finish shuffle for appId[" + appId + "], shuffleId[" + shuffleId + "], data may be lost";
            try {
                LOG.info("Get finishShuffle request for appId[" + appId + "], shuffleId[" + shuffleId + "]");
                status = this.shuffleServer.getShuffleTaskManager().commitShuffle(appId, shuffleId);
                if (status != StatusCode.SUCCESS) {
                    status = StatusCode.INTERNAL_ERROR;
                    msg = errorMsg;
                }
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                msg = errorMsg;
                LOG.error(errorMsg, (Throwable)e);
            }
            auditContext.withStatusCode(status);
            RssProtos.FinishShuffleResponse response = RssProtos.FinishShuffleResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    public void requireBuffer(RssProtos.RequireBufferRequest request, StreamObserver<RssProtos.RequireBufferResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("requireBuffer");){
            String appId = request.getAppId();
            auditContext.withAppId(appId).withShuffleId(request.getShuffleId());
            String auditArgs = "requireSize=" + request.getRequireSize();
            if (request.getPartitionIdsList() != null) {
                auditArgs = auditArgs + ", partitionIdsSize=" + request.getPartitionIdsList().size();
            }
            if (request.getPartitionIdsList() != null) {
                auditArgs = auditArgs + ", partitionIds=" + OutputUtils.listToSegment((List)request.getPartitionIdsList(), (long)1L, (long)10L);
            }
            auditContext.withArgs(auditArgs);
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.RequireBufferResponse response = RssProtos.RequireBufferResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
                return;
            }
            long requireBufferId = -1L;
            String responseMessage = "";
            String shuffleDataInfo = "appId[" + appId + "], shuffleId[" + request.getShuffleId() + "]";
            List needSplitPartitionIds = Collections.emptyList();
            try {
                if (StringUtils.isEmpty((CharSequence)appId)) {
                    requireBufferId = this.shuffleServer.getShuffleTaskManager().requireBuffer(request.getRequireSize());
                } else {
                    Pair<Long, List<Integer>> pair = this.shuffleServer.getShuffleTaskManager().requireBufferReturnPair(appId, request.getShuffleId(), request.getPartitionIdsList(), request.getPartitionRequireSizesList(), request.getRequireSize());
                    requireBufferId = (Long)pair.getLeft();
                    needSplitPartitionIds = (List)pair.getRight();
                }
            }
            catch (NoBufferException e) {
                responseMessage = e.getMessage();
                status = StatusCode.NO_BUFFER;
                ShuffleServerMetrics.counterTotalRequireBufferFailedForRegularPartition.inc();
                ShuffleServerMetrics.counterTotalRequireBufferFailed.inc();
            }
            catch (NoBufferForHugePartitionException e) {
                responseMessage = e.getMessage();
                status = StatusCode.NO_BUFFER_FOR_HUGE_PARTITION;
                ShuffleServerMetrics.counterTotalRequireBufferFailedForHugePartition.inc();
                ShuffleServerMetrics.counterTotalRequireBufferFailed.inc();
            }
            catch (NoRegisterException e) {
                responseMessage = e.getMessage();
                status = StatusCode.NO_REGISTER;
                ShuffleServerMetrics.counterTotalRequireBufferFailed.inc();
            }
            catch (ExceedHugePartitionHardLimitException e) {
                status = StatusCode.EXCEED_HUGE_PARTITION_HARD_LIMIT;
                ShuffleServerMetrics.counterTotalHugePartitionExceedHardLimitNum.inc();
                ShuffleServerMetrics.counterTotalRequireBufferFailed.inc();
                responseMessage = "ExceedHugePartitionHardLimitException Error happened when requireBuffer for " + shuffleDataInfo + ": " + e.getMessage();
                LOG.error(responseMessage);
            }
            auditContext.withStatusCode(status);
            auditContext.withReturnValue("requireBufferId=" + requireBufferId);
            RssProtos.RequireBufferResponse response = RssProtos.RequireBufferResponse.newBuilder().setStatus(status.toProto()).setRequireBufferId(requireBufferId).setRetMsg(responseMessage).addAllNeedSplitPartitionIds((Iterable)needSplitPartitionIds).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    public void appHeartbeat(RssProtos.AppHeartBeatRequest request, StreamObserver<RssProtos.AppHeartBeatResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("appHeartbeat");){
            String appId = request.getAppId();
            auditContext.withAppId(appId);
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.AppHeartBeatResponse response = RssProtos.AppHeartBeatResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
                return;
            }
            if (Context.current().isCancelled()) {
                auditContext.withStatusCode("CANCELLED");
                responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
                LOG.warn("Cancelled by client {} for after deadline.", (Object)appId);
                return;
            }
            LOG.info("Get heartbeat from {}", (Object)appId);
            auditContext.withStatusCode(StatusCode.SUCCESS);
            this.shuffleServer.getShuffleTaskManager().refreshAppId(appId);
            if (this.shuffleServer.isRemoteMergeEnable()) {
                this.shuffleServer.getShuffleMergeManager().refreshAppId(appId);
            }
            RssProtos.AppHeartBeatResponse response = RssProtos.AppHeartBeatResponse.newBuilder().setRetMsg("").setStatus(StatusCode.SUCCESS.toProto()).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }

    public void reportShuffleResult(RssProtos.ReportShuffleResultRequest request, StreamObserver<RssProtos.ReportShuffleResultResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("reportShuffleResult");){
            String appId = request.getAppId();
            int shuffleId = request.getShuffleId();
            long taskAttemptId = request.getTaskAttemptId();
            int bitmapNum = request.getBitmapNum();
            Map<Integer, long[]> partitionToBlockIds = this.toPartitionBlocksMap(request.getPartitionToBlockIdsList());
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            auditContext.withArgs("taskAttemptId=" + taskAttemptId + ", bitmapNum=" + bitmapNum + ", partitionToBlockIdsSize=" + partitionToBlockIds.size());
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.ReportShuffleResultResponse response = RssProtos.ReportShuffleResultResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
                return;
            }
            String msg = "OK";
            String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], taskAttemptId[" + taskAttemptId + "]";
            try {
                long start = System.currentTimeMillis();
                int expectedBlockCount = partitionToBlockIds.values().stream().mapToInt(x -> ((long[])x).length).sum();
                LOG.debug("Accepted blockIds report for {} blocks across {} partitions as shuffle result for task {}", new Object[]{expectedBlockCount, partitionToBlockIds.size(), requestInfo});
                int updatedBlockCount = this.shuffleServer.getShuffleTaskManager().addFinishedBlockIds(appId, shuffleId, partitionToBlockIds, bitmapNum);
                long costTime = System.currentTimeMillis() - start;
                this.shuffleServer.getGrpcMetrics().recordProcessTime("reportShuffleResult", costTime);
                if (expectedBlockCount != updatedBlockCount) {
                    LOG.warn("Existing {} duplicated blockIds on blockId report for appId: {}, shuffleId: {}", new Object[]{expectedBlockCount - updatedBlockCount, appId, shuffleId});
                }
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                msg = "error happened when report shuffle result, check shuffle server for detail";
                LOG.error("Error happened when report shuffle result for " + requestInfo, (Throwable)e);
            }
            auditContext.withStatusCode(status);
            RssProtos.ReportShuffleResultResponse reply = RssProtos.ReportShuffleResultResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    public void getShuffleResult(RssProtos.GetShuffleResultRequest request, StreamObserver<RssProtos.GetShuffleResultResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("getShuffleResult");){
            String appId = request.getAppId();
            int shuffleId = request.getShuffleId();
            int partitionId = request.getPartitionId();
            BlockIdLayout blockIdLayout = BlockIdLayout.from((int)request.getBlockIdLayout().getSequenceNoBits(), (int)request.getBlockIdLayout().getPartitionIdBits(), (int)request.getBlockIdLayout().getTaskAttemptIdBits());
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            auditContext.withArgs("partitionId=" + partitionId + ", blockIdLayout=" + blockIdLayout);
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.GetShuffleResultResponse response = RssProtos.GetShuffleResultResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
                return;
            }
            String msg = "OK";
            byte[] serializedBlockIds = null;
            String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
            ByteString serializedBlockIdsBytes = ByteString.EMPTY;
            try {
                serializedBlockIds = this.shuffleServer.getShuffleTaskManager().getFinishedBlockIds(appId, shuffleId, Sets.newHashSet(partitionId), blockIdLayout);
                if (serializedBlockIds == null) {
                    status = StatusCode.INTERNAL_ERROR;
                    msg = "Can't get shuffle result for " + requestInfo;
                    LOG.warn(msg);
                } else {
                    serializedBlockIdsBytes = UnsafeByteOperations.unsafeWrap((byte[])serializedBlockIds);
                }
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                msg = e.getMessage();
                LOG.error("Error happened when get shuffle result for {}", (Object)requestInfo, (Object)e);
            }
            auditContext.withStatusCode(status);
            RssProtos.GetShuffleResultResponse reply = RssProtos.GetShuffleResultResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setSerializedBitmap(serializedBlockIdsBytes).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    public void getShuffleResultForMultiPart(RssProtos.GetShuffleResultForMultiPartRequest request, StreamObserver<RssProtos.GetShuffleResultForMultiPartResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("getShuffleResultForMultiPart");){
            String appId = request.getAppId();
            int shuffleId = request.getShuffleId();
            List partitionsList = request.getPartitionsList();
            BlockIdLayout blockIdLayout = BlockIdLayout.from((int)request.getBlockIdLayout().getSequenceNoBits(), (int)request.getBlockIdLayout().getPartitionIdBits(), (int)request.getBlockIdLayout().getTaskAttemptIdBits());
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            String partitionIdsOutput = OutputUtils.listToSegment((List)partitionsList, (long)1L, (long)10L);
            auditContext.withArgs("partitionsListSize=" + partitionsList.size() + ", partitionIds=" + partitionIdsOutput + ", blockIdLayout=" + blockIdLayout);
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.GetShuffleResultForMultiPartResponse response = RssProtos.GetShuffleResultForMultiPartResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
                return;
            }
            String msg = "OK";
            byte[] serializedBlockIds = null;
            String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitions=" + partitionIdsOutput;
            ByteString serializedBlockIdsBytes = ByteString.EMPTY;
            try {
                long start = System.currentTimeMillis();
                serializedBlockIds = this.shuffleServer.getShuffleTaskManager().getFinishedBlockIds(appId, shuffleId, Sets.newHashSet(partitionsList), blockIdLayout);
                if (serializedBlockIds == null) {
                    status = StatusCode.INTERNAL_ERROR;
                    msg = "Can't get shuffle result for " + requestInfo;
                    LOG.warn(msg);
                } else {
                    serializedBlockIdsBytes = UnsafeByteOperations.unsafeWrap((byte[])serializedBlockIds);
                    long costTime = System.currentTimeMillis() - start;
                    this.shuffleServer.getGrpcMetrics().recordProcessTime("getShuffleResultForMultiPart", costTime);
                }
            }
            catch (Exception e) {
                status = StatusCode.INTERNAL_ERROR;
                msg = e.getMessage();
                LOG.error("Error happened when get shuffle result for {}", (Object)requestInfo, (Object)e);
            }
            auditContext.withStatusCode(status);
            RssProtos.GetShuffleResultForMultiPartResponse reply = RssProtos.GetShuffleResultForMultiPartResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setSerializedBitmap(serializedBlockIdsBytes).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLocalShuffleData(RssProtos.GetLocalShuffleDataRequest request, StreamObserver<RssProtos.GetLocalShuffleDataResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("getLocalShuffleData");){
            long transportTime;
            String appId = request.getAppId();
            int shuffleId = request.getShuffleId();
            int partitionId = request.getPartitionId();
            int partitionNumPerRange = request.getPartitionNumPerRange();
            int partitionNum = request.getPartitionNum();
            long offset = request.getOffset();
            int length = request.getLength();
            int storageId = request.getStorageId();
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            auditContext.withArgs("partitionId=" + partitionId + ", partitionNumPerRange=" + partitionNumPerRange + ", partitionNum=" + partitionNum + ", offset=" + offset + ", length=" + length + ", storageId=" + storageId);
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.GetLocalShuffleDataResponse response = RssProtos.GetLocalShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
                return;
            }
            long timestamp = request.getTimestamp();
            if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
                this.shuffleServer.getGrpcMetrics().recordTransportTime("getLocalShuffleData", transportTime);
            }
            String storageType = ((StorageType)this.shuffleServer.getShuffleServerConf().get(RssBaseConf.RSS_STORAGE_TYPE)).name();
            String msg = "OK";
            RssProtos.GetLocalShuffleDataResponse reply = null;
            ShuffleDataResult sdr = null;
            String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]offset[" + offset + "]length[" + length + "]";
            int[] range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
            Storage storage = this.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0], storageId));
            if (storage != null) {
                storage.updateReadMetrics(new StorageReadMetrics(appId, shuffleId));
            }
            if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(length)) {
                try {
                    long start = System.currentTimeMillis();
                    sdr = this.shuffleServer.getShuffleTaskManager().getShuffleData(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum, storageType, offset, length, storageId);
                    reply = RssProtos.GetLocalShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setData(UnsafeByteOperations.unsafeWrap((byte[])sdr.getData())).build();
                    long readTime = System.currentTimeMillis() - start;
                    ShuffleServerMetrics.counterTotalReadTime.inc((double)readTime);
                    ShuffleServerMetrics.counterTotalReadDataSize.inc((double)sdr.getDataLength());
                    ShuffleServerMetrics.counterTotalReadLocalDataFileSize.inc((double)sdr.getDataLength());
                    ShuffleServerMetrics.gaugeReadLocalDataFileThreadNum.inc();
                    ShuffleServerMetrics.gaugeReadLocalDataFileBufferSize.inc((double)length);
                    this.shuffleServer.getGrpcMetrics().recordProcessTime("getLocalShuffleData", readTime);
                    LOG.info("Successfully getShuffleData cost {} ms for shuffle data with {}", (Object)readTime, (Object)requestInfo);
                }
                catch (Exception e) {
                    status = StatusCode.INTERNAL_ERROR;
                    msg = "Error happened when get shuffle data for " + requestInfo + ", " + e.getMessage();
                    LOG.error(msg, (Throwable)e);
                    reply = RssProtos.GetLocalShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
                }
                finally {
                    if (sdr != null) {
                        sdr.release();
                        ShuffleServerMetrics.gaugeReadLocalDataFileThreadNum.dec();
                        ShuffleServerMetrics.gaugeReadLocalDataFileBufferSize.dec((double)length);
                    }
                    this.shuffleServer.getShuffleBufferManager().releaseReadMemory(length);
                }
            } else {
                status = StatusCode.NO_BUFFER;
                msg = "Can't require memory to get shuffle data";
                LOG.warn("{} for {}", (Object)msg, (Object)requestInfo);
                reply = RssProtos.GetLocalShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
            }
            auditContext.withStatusCode(status);
            auditContext.withReturnValue("len=" + (sdr == null ? 0 : sdr.getDataLength()));
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLocalShuffleIndex(RssProtos.GetLocalShuffleIndexRequest request, StreamObserver<RssProtos.GetLocalShuffleIndexResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("getLocalShuffleIndex");){
            RssProtos.GetLocalShuffleIndexResponse reply;
            String appId = request.getAppId();
            int shuffleId = request.getShuffleId();
            int partitionId = request.getPartitionId();
            int partitionNumPerRange = request.getPartitionNumPerRange();
            int partitionNum = request.getPartitionNum();
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            auditContext.withArgs("partitionId=" + partitionId + ", partitionNumPerRange=" + partitionNumPerRange + ", partitionNum=" + partitionNum);
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.GetLocalShuffleIndexResponse reply2 = RssProtos.GetLocalShuffleIndexResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)reply2);
                responseObserver.onCompleted();
                return;
            }
            String msg = "OK";
            String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
            int[] range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
            Storage storage = this.shuffleServer.getStorageManager().selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0]));
            if (storage != null) {
                storage.updateReadMetrics(new StorageReadMetrics(appId, shuffleId));
            }
            long assumedFileSize = this.shuffleServer.getShuffleServerConf().getLong(ShuffleServerConf.SERVER_SHUFFLE_INDEX_SIZE_HINT);
            if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(assumedFileSize)) {
                ShuffleIndexResult shuffleIndexResult = null;
                try {
                    long start = System.currentTimeMillis();
                    shuffleIndexResult = this.shuffleServer.getShuffleTaskManager().getShuffleIndex(appId, shuffleId, partitionId, partitionNumPerRange, partitionNum);
                    ByteBuffer data = shuffleIndexResult.getIndexData();
                    ShuffleServerMetrics.counterTotalReadDataSize.inc((double)data.remaining());
                    ShuffleServerMetrics.counterTotalReadLocalIndexFileSize.inc((double)data.remaining());
                    ShuffleServerMetrics.gaugeReadLocalIndexFileThreadNum.inc();
                    ShuffleServerMetrics.gaugeReadLocalIndexFileBufferSize.inc((double)assumedFileSize);
                    RssProtos.GetLocalShuffleIndexResponse.Builder builder = RssProtos.GetLocalShuffleIndexResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg);
                    builder.setIndexData(UnsafeByteOperations.unsafeWrap((ByteBuffer)data));
                    builder.setDataFileLen(shuffleIndexResult.getDataFileLen());
                    builder.addAllStorageIds((Iterable)Arrays.stream(shuffleIndexResult.getStorageIds()).boxed().collect(Collectors.toList()));
                    long readTime = System.currentTimeMillis() - start;
                    this.shuffleServer.getGrpcMetrics().recordProcessTime("getLocalShuffleIndex", readTime);
                    LOG.info("Successfully getShuffleIndex cost {} ms for {} bytes with {}", new Object[]{readTime, data.remaining(), requestInfo});
                    auditContext.withReturnValue("len=" + shuffleIndexResult.getDataFileLen());
                    reply = builder.build();
                }
                catch (FileNotFoundException indexFileNotFoundException) {
                    LOG.warn("Index file for {} is not found, maybe the data has been flushed to cold storage or still in memory buffer pool.", (Object)requestInfo, (Object)indexFileNotFoundException);
                    reply = RssProtos.GetLocalShuffleIndexResponse.newBuilder().setStatus(status.toProto()).build();
                }
                catch (Exception e) {
                    status = StatusCode.INTERNAL_ERROR;
                    msg = "Error happened when get shuffle index for " + requestInfo + ", " + e.getMessage();
                    LOG.error(msg, (Throwable)e);
                    reply = RssProtos.GetLocalShuffleIndexResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
                }
                finally {
                    if (shuffleIndexResult != null) {
                        shuffleIndexResult.release();
                        ShuffleServerMetrics.gaugeReadLocalIndexFileThreadNum.dec();
                        ShuffleServerMetrics.gaugeReadLocalIndexFileBufferSize.dec((double)assumedFileSize);
                    }
                    this.shuffleServer.getShuffleBufferManager().releaseReadMemory(assumedFileSize);
                }
            } else {
                status = StatusCode.NO_BUFFER;
                msg = "Can't require memory to get shuffle index";
                LOG.warn("{} for {}", (Object)msg, (Object)requestInfo);
                reply = RssProtos.GetLocalShuffleIndexResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
            }
            auditContext.withStatusCode(status);
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMemoryShuffleData(RssProtos.GetMemoryShuffleDataRequest request, StreamObserver<RssProtos.GetMemoryShuffleDataResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("getMemoryShuffleData");){
            RssProtos.GetMemoryShuffleDataResponse reply;
            long transportTime;
            String appId = request.getAppId();
            int shuffleId = request.getShuffleId();
            int partitionId = request.getPartitionId();
            long blockId = request.getLastBlockId();
            int readBufferSize = request.getReadBufferSize();
            auditContext.withAppId(appId).withShuffleId(shuffleId);
            auditContext.withArgs("partitionId=" + partitionId + ", blockId=" + blockId + ", readBufferSize=" + readBufferSize);
            StatusCode status = this.verifyRequest(appId);
            if (status != StatusCode.SUCCESS) {
                auditContext.withStatusCode(status);
                RssProtos.GetMemoryShuffleDataResponse reply2 = RssProtos.GetMemoryShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(status.toString()).build();
                responseObserver.onNext((Object)reply2);
                responseObserver.onCompleted();
                return;
            }
            long timestamp = request.getTimestamp();
            if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
                this.shuffleServer.getGrpcMetrics().recordTransportTime("getMemoryShuffleData", transportTime);
            }
            String msg = "OK";
            String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
            if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(readBufferSize)) {
                ShuffleDataResult shuffleDataResult = null;
                try {
                    long start = System.currentTimeMillis();
                    Roaring64NavigableMap expectedTaskIds = null;
                    if (request.getSerializedExpectedTaskIdsBitmap() != null && !request.getSerializedExpectedTaskIdsBitmap().isEmpty()) {
                        expectedTaskIds = RssUtils.deserializeBitMap((byte[])request.getSerializedExpectedTaskIdsBitmap().toByteArray());
                    }
                    shuffleDataResult = this.shuffleServer.getShuffleTaskManager().getInMemoryShuffleData(appId, shuffleId, partitionId, blockId, readBufferSize, expectedTaskIds);
                    byte[] data = new byte[]{};
                    List<BufferSegment> bufferSegments = Lists.newArrayList();
                    if (shuffleDataResult != null) {
                        data = shuffleDataResult.getData();
                        bufferSegments = shuffleDataResult.getBufferSegments();
                        ShuffleServerMetrics.counterTotalReadDataSize.inc((double)data.length);
                        ShuffleServerMetrics.counterTotalReadMemoryDataSize.inc((double)data.length);
                        ShuffleServerMetrics.gaugeReadMemoryDataThreadNum.inc();
                        ShuffleServerMetrics.gaugeReadMemoryDataBufferSize.inc((double)readBufferSize);
                    }
                    long costTime = System.currentTimeMillis() - start;
                    this.shuffleServer.getGrpcMetrics().recordProcessTime("getMemoryShuffleData", costTime);
                    LOG.info("Successfully getInMemoryShuffleData cost {} ms with {} bytes shuffle data for {}", new Object[]{costTime, data.length, requestInfo});
                    auditContext.withReturnValue("len=" + data.length + ", bufferSegmentSize=" + bufferSegments.size());
                    reply = RssProtos.GetMemoryShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setData(UnsafeByteOperations.unsafeWrap((byte[])data)).addAllShuffleDataBlockSegments(this.toShuffleDataBlockSegments(bufferSegments)).build();
                }
                catch (Exception e) {
                    status = StatusCode.INTERNAL_ERROR;
                    msg = "Error happened when get in memory shuffle data for " + requestInfo + ", " + e.getMessage();
                    LOG.error(msg, (Throwable)e);
                    reply = RssProtos.GetMemoryShuffleDataResponse.newBuilder().setData(UnsafeByteOperations.unsafeWrap((byte[])new byte[0])).addAllShuffleDataBlockSegments(Lists.newArrayList()).setStatus(status.toProto()).setRetMsg(msg).build();
                }
                finally {
                    if (shuffleDataResult != null) {
                        shuffleDataResult.release();
                        ShuffleServerMetrics.gaugeReadMemoryDataThreadNum.dec();
                        ShuffleServerMetrics.gaugeReadMemoryDataBufferSize.dec((double)readBufferSize);
                    }
                    this.shuffleServer.getShuffleBufferManager().releaseReadMemory(readBufferSize);
                }
            } else {
                status = StatusCode.NO_BUFFER;
                msg = "Can't require memory to get in memory shuffle data";
                LOG.warn("{} for {}", (Object)msg, (Object)requestInfo);
                reply = RssProtos.GetMemoryShuffleDataResponse.newBuilder().setData(UnsafeByteOperations.unsafeWrap((byte[])new byte[0])).addAllShuffleDataBlockSegments(Lists.newArrayList()).setStatus(status.toProto()).setRetMsg(msg).build();
            }
            auditContext.withStatusCode(status);
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    public void startSortMerge(RssProtos.StartSortMergeRequest request, StreamObserver<RssProtos.StartSortMergeResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("startSortMerge");){
            String appId = request.getAppId();
            int shuffleId = request.getShuffleId();
            int partitionId = request.getPartitionId();
            auditContext.withAppId(appId).withShuffleId(shuffleId).withArgs(String.format("partitionId=%d", partitionId));
            StatusCode status = StatusCode.SUCCESS;
            String msg = "OK";
            String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]";
            try {
                Roaring64NavigableMap expectedBlockIdMap = RssUtils.deserializeBitMap((byte[])request.getUniqueBlocksBitmap().toByteArray());
                LOG.info("Report " + expectedBlockIdMap.getLongCardinality() + " unique blocks for " + requestInfo);
                if (this.shuffleServer.isRemoteMergeEnable()) {
                    this.shuffleServer.getShuffleMergeManager().startSortMerge(appId, shuffleId, partitionId, expectedBlockIdMap);
                } else {
                    status = StatusCode.INTERNAL_ERROR;
                    msg = "Remote merge is disabled, can not report StartSortMerge!";
                }
            }
            catch (IOException e) {
                status = StatusCode.INTERNAL_ERROR;
                msg = e.getMessage();
                LOG.error("Error happened when report unique blocks for {}, {}", (Object)requestInfo, (Object)e);
            }
            RssProtos.StartSortMergeResponse reply = RssProtos.StartSortMergeResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSortedShuffleData(RssProtos.GetSortedShuffleDataRequest request, StreamObserver<RssProtos.GetSortedShuffleDataResponse> responseObserver) {
        try (ServerRpcAuditContext auditContext = this.createAuditContext("getSortedShuffleData");){
            long transportTime;
            String appId = request.getAppId();
            int shuffleId = request.getShuffleId();
            int partitionId = request.getPartitionId();
            long blockId = request.getMergedBlockId();
            long timestamp = request.getTimestamp();
            auditContext.withAppId(appId).withShuffleId(shuffleId).withArgs(String.format("partitionId=%d, blockId=%d", partitionId, blockId));
            if (timestamp > 0L && (transportTime = System.currentTimeMillis() - timestamp) > 0L) {
                this.shuffleServer.getGrpcMetrics().recordTransportTime("getSortedShuffleData", transportTime);
            }
            StatusCode status = StatusCode.SUCCESS;
            String msg = "OK";
            RssProtos.GetSortedShuffleDataResponse reply = null;
            ShuffleDataResult sdr = null;
            String requestInfo = "appId[" + appId + "], shuffleId[" + shuffleId + "], partitionId[" + partitionId + "]blockId[" + blockId + "]";
            if (!this.shuffleServer.isRemoteMergeEnable()) {
                msg = "Remote merge is disabled";
                status = StatusCode.INTERNAL_ERROR;
                reply = RssProtos.GetSortedShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
                return;
            }
            MergeStatus mergeStatus = this.shuffleServer.getShuffleMergeManager().tryGetBlock(appId, shuffleId, partitionId, blockId);
            MergeState mergeState = mergeStatus.getState();
            long blockSize = mergeStatus.getSize();
            if (mergeState == MergeState.INITED) {
                msg = MergeState.INITED.name();
                reply = RssProtos.GetSortedShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setMState(mergeState.code()).build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
                return;
            }
            if (mergeState == MergeState.MERGING && blockSize == -1L) {
                msg = MergeState.MERGING.name();
                reply = RssProtos.GetSortedShuffleDataResponse.newBuilder().setStatus(status.toProto()).setNextBlockId(-1L).setRetMsg(msg).setMState(mergeState.code()).build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
                return;
            }
            if (mergeState == MergeState.DONE && blockSize == -1L) {
                msg = MergeState.DONE.name();
                reply = RssProtos.GetSortedShuffleDataResponse.newBuilder().setStatus(status.toProto()).setNextBlockId(-1L).setRetMsg(msg).setMState(mergeState.code()).build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
                return;
            }
            if (mergeState == MergeState.INTERNAL_ERROR) {
                msg = MergeState.INTERNAL_ERROR.name();
                status = StatusCode.INTERNAL_ERROR;
                reply = RssProtos.GetSortedShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).setMState(mergeState.code()).build();
                responseObserver.onNext((Object)reply);
                responseObserver.onCompleted();
                return;
            }
            if (this.shuffleServer.getShuffleBufferManager().requireReadMemory(blockSize)) {
                try {
                    long start = System.currentTimeMillis();
                    sdr = this.shuffleServer.getShuffleMergeManager().getShuffleData(appId, shuffleId, partitionId, blockId);
                    long readTime = System.currentTimeMillis() - start;
                    ShuffleServerMetrics.counterTotalReadTime.inc((double)readTime);
                    ShuffleServerMetrics.counterTotalReadDataSize.inc((double)sdr.getDataLength());
                    ShuffleServerMetrics.counterTotalReadLocalDataFileSize.inc((double)sdr.getDataLength());
                    this.shuffleServer.getGrpcMetrics().recordProcessTime("getSortedShuffleData", readTime);
                    LOG.info("Successfully getSortedShuffleData cost {} ms for shuffle data with {}, length is {}, state is {}", new Object[]{readTime, requestInfo, sdr.getDataLength(), mergeState});
                    auditContext.withReturnValue("len=" + sdr.getDataLength());
                    reply = RssProtos.GetSortedShuffleDataResponse.newBuilder().setNextBlockId(blockId + 1L).setMState(mergeState.code()).setStatus(status.toProto()).setRetMsg(msg).setData(UnsafeByteOperations.unsafeWrap((byte[])sdr.getData(), (int)0, (int)sdr.getDataLength())).build();
                }
                catch (Exception e) {
                    status = StatusCode.INTERNAL_ERROR;
                    msg = "Error happened when get shuffle data for " + requestInfo + ", " + e.getMessage();
                    LOG.error(msg, (Throwable)e);
                    reply = RssProtos.GetSortedShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
                }
                finally {
                    if (sdr != null) {
                        sdr.release();
                    }
                    this.shuffleServer.getShuffleBufferManager().releaseReadMemory(blockSize);
                }
            } else {
                status = StatusCode.NO_BUFFER;
                msg = "Can't require read memory to get sorted shuffle data";
                LOG.error(msg + " for " + requestInfo);
                reply = RssProtos.GetSortedShuffleDataResponse.newBuilder().setStatus(status.toProto()).setRetMsg(msg).build();
            }
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
    }

    private List<ShufflePartitionedData> toPartitionedDataList(RssProtos.SendShuffleDataRequest req) {
        ArrayList<ShufflePartitionedData> ret = Lists.newArrayList();
        for (RssProtos.ShuffleData data : req.getShuffleDataList()) {
            ret.add(this.toPartitionedData(data.getPartitionId(), data.getBlockList()));
        }
        return ret;
    }

    private ShufflePartitionedData toPartitionedData(int partitionId, List<RssProtos.ShuffleBlock> blocks) {
        if (blocks == null || blocks.size() == 0) {
            return new ShufflePartitionedData(partitionId, 0L, 0L, new ShufflePartitionedBlock[0]);
        }
        ShufflePartitionedBlock[] ret = new ShufflePartitionedBlock[blocks.size()];
        long encodedLength = 0L;
        long dataLength = 0L;
        int i = 0;
        for (RssProtos.ShuffleBlock block : blocks) {
            ByteBuf data = ByteBufUtils.byteStringToByteBuf((ByteString)block.getData());
            ret[i] = new ShufflePartitionedBlock(block.getLength(), block.getUncompressLength(), block.getCrc(), block.getBlockId(), block.getTaskAttemptId(), data);
            encodedLength += ret[i].getEncodedLength();
            dataLength += (long)ret[i].getDataLength();
            ++i;
        }
        return new ShufflePartitionedData(partitionId, encodedLength, dataLength, ret);
    }

    private Map<Integer, long[]> toPartitionBlocksMap(List<RssProtos.PartitionToBlockIds> partitionToBlockIds) {
        HashMap<Integer, long[]> result = Maps.newHashMap();
        for (RssProtos.PartitionToBlockIds ptb : partitionToBlockIds) {
            List blockIds = ptb.getBlockIdsList();
            if (blockIds == null || blockIds.isEmpty()) continue;
            long[] array = new long[blockIds.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Long)blockIds.get(i);
            }
            result.put(ptb.getPartitionId(), array);
        }
        return result;
    }

    private List<PartitionRange> toPartitionRanges(List<RssProtos.ShufflePartitionRange> shufflePartitionRanges) {
        ArrayList<PartitionRange> partitionRanges = Lists.newArrayList();
        for (RssProtos.ShufflePartitionRange spr : shufflePartitionRanges) {
            partitionRanges.add(new PartitionRange(spr.getStart(), spr.getEnd()));
        }
        return partitionRanges;
    }

    private List<RssProtos.ShuffleDataBlockSegment> toShuffleDataBlockSegments(List<BufferSegment> bufferSegments) {
        ArrayList<RssProtos.ShuffleDataBlockSegment> shuffleDataBlockSegments = Lists.newArrayList();
        if (bufferSegments != null) {
            for (BufferSegment bs : bufferSegments) {
                shuffleDataBlockSegments.add(RssProtos.ShuffleDataBlockSegment.newBuilder().setBlockId(bs.getBlockId()).setCrc(bs.getCrc()).setOffset((long)bs.getOffset()).setLength(bs.getLength()).setTaskAttemptId(bs.getTaskAttemptId()).setUncompressLength(bs.getUncompressLength()).build());
            }
        }
        return shuffleDataBlockSegments;
    }

    private StatusCode verifyRequest(String appId) {
        if (StringUtils.isNotBlank((CharSequence)appId) && this.shuffleServer.getShuffleTaskManager().isAppExpired(appId)) {
            return StatusCode.NO_REGISTER;
        }
        return StatusCode.SUCCESS;
    }

    private ServerRpcAuditContext createAuditContext(String command) {
        Logger auditLogger = null;
        if (this.isRpcAuditLogEnabled && !this.rpcAuditExcludeOpList.contains(command)) {
            auditLogger = AUDIT_LOGGER;
        }
        ServerRpcAuditContext auditContext = new ServerRpcAuditContext(auditLogger);
        if (auditLogger != null) {
            auditContext.withCommand(command).withFrom(ClientContextServerInterceptor.getIpAddress()).withCreationTimeNs(System.nanoTime());
        }
        return auditContext;
    }
}

