/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.ShufflePartitionedData;
import org.apache.uniffle.common.StorageType;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.exception.FileNotFoundException;
import org.apache.uniffle.common.exception.InvalidRequestException;
import org.apache.uniffle.common.exception.NoBufferException;
import org.apache.uniffle.common.exception.NoBufferForHugePartitionException;
import org.apache.uniffle.common.exception.NoRegisterException;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.future.CompletableFutureExtension;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.BlockIdLayout;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.OutputUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.common.util.UnitConverter;
import org.apache.uniffle.server.HugePartitionUtils;
import org.apache.uniffle.server.ShuffleDataReadEvent;
import org.apache.uniffle.server.ShuffleFlushManager;
import org.apache.uniffle.server.ShuffleServerConf;
import org.apache.uniffle.server.ShuffleServerMetrics;
import org.apache.uniffle.server.ShuffleSpecification;
import org.apache.uniffle.server.ShuffleTaskInfo;
import org.apache.uniffle.server.TopNShuffleDataSizeOfAppCalcTask;
import org.apache.uniffle.server.block.ShuffleBlockIdManager;
import org.apache.uniffle.server.block.ShuffleBlockIdManagerFactory;
import org.apache.uniffle.server.buffer.PreAllocatedBufferInfo;
import org.apache.uniffle.server.buffer.ShuffleBuffer;
import org.apache.uniffle.server.buffer.ShuffleBufferManager;
import org.apache.uniffle.server.event.AppPurgeEvent;
import org.apache.uniffle.server.event.AppUnregisterPurgeEvent;
import org.apache.uniffle.server.event.PurgeEvent;
import org.apache.uniffle.server.event.ShufflePurgeEvent;
import org.apache.uniffle.server.merge.ShuffleMergeManager;
import org.apache.uniffle.server.storage.StorageManager;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.guava.cache.Cache;
import org.apache.uniffle.shaded.guava.cache.CacheBuilder;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.apache.uniffle.shaded.guava.collect.Queues;
import org.apache.uniffle.shaded.guava.collect.Range;
import org.apache.uniffle.shaded.guava.collect.Sets;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.common.StorageReadMetrics;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleTaskManager.class);
    private final boolean storageTypeWithMemory;
    private ShuffleFlushManager shuffleFlushManager;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ScheduledExecutorService expiredAppCleanupExecutorService;
    private final ScheduledExecutorService leakShuffleDataCheckExecutorService;
    private ScheduledExecutorService triggerFlushExecutorService;
    private final TopNShuffleDataSizeOfAppCalcTask topNShuffleDataSizeOfAppCalcTask;
    private StorageManager storageManager;
    private AtomicLong requireBufferId = new AtomicLong(0L);
    private ShuffleServerConf conf;
    private long appExpiredWithoutHB;
    private long preAllocationExpired;
    private long commitCheckIntervalMax;
    private long leakShuffleDataCheckInterval;
    private long triggerFlushInterval;
    private final ShuffleBufferManager shuffleBufferManager;
    private Map<String, ShuffleTaskInfo> shuffleTaskInfos = JavaUtils.newConcurrentMap();
    private Map<Long, PreAllocatedBufferInfo> requireBufferIds = JavaUtils.newConcurrentMap();
    private final Map<String, Long> removingApps = JavaUtils.newConcurrentMap();
    private Thread clearResourceThread;
    private BlockingQueue<PurgeEvent> expiredAppIdQueue = Queues.newLinkedBlockingQueue();
    private final Cache<String, ReentrantReadWriteLock> appLocks;
    private final long storageRemoveOperationTimeoutSec;
    private ShuffleMergeManager shuffleMergeManager;
    private ShuffleBlockIdManager shuffleBlockIdManager;

    public ShuffleTaskManager(ShuffleServerConf conf, ShuffleFlushManager shuffleFlushManager, ShuffleBufferManager shuffleBufferManager, StorageManager storageManager) {
        this(conf, shuffleFlushManager, shuffleBufferManager, storageManager, null);
    }

    public ShuffleTaskManager(ShuffleServerConf conf, ShuffleFlushManager shuffleFlushManager, ShuffleBufferManager shuffleBufferManager, StorageManager storageManager, ShuffleMergeManager shuffleMergeManager) {
        this.conf = conf;
        this.shuffleFlushManager = shuffleFlushManager;
        this.shuffleBufferManager = shuffleBufferManager;
        this.storageManager = storageManager;
        this.shuffleMergeManager = shuffleMergeManager;
        StorageType storageType = (StorageType)conf.get(ShuffleServerConf.RSS_STORAGE_TYPE);
        this.storageTypeWithMemory = storageType == null ? false : org.apache.uniffle.storage.util.StorageType.withMemory((org.apache.uniffle.storage.util.StorageType)org.apache.uniffle.storage.util.StorageType.valueOf((String)storageType.name()));
        this.appExpiredWithoutHB = conf.getLong(ShuffleServerConf.SERVER_APP_EXPIRED_WITHOUT_HEARTBEAT);
        this.commitCheckIntervalMax = conf.getLong(ShuffleServerConf.SERVER_COMMIT_CHECK_INTERVAL_MAX);
        this.preAllocationExpired = conf.getLong(ShuffleServerConf.SERVER_PRE_ALLOCATION_EXPIRED);
        this.storageRemoveOperationTimeoutSec = conf.getLong(ShuffleServerConf.STORAGE_REMOVE_RESOURCE_OPERATION_TIMEOUT_SEC);
        this.leakShuffleDataCheckInterval = conf.getLong(ShuffleServerConf.SERVER_LEAK_SHUFFLE_DATA_CHECK_INTERVAL);
        boolean bufferFlushWhenCachingData = conf.getBoolean(ShuffleServerConf.BUFFER_FLUSH_TRIGGERED_WHEN_CACHEING_DATA);
        this.triggerFlushInterval = conf.getLong(ShuffleServerConf.SERVER_TRIGGER_FLUSH_CHECK_INTERVAL);
        assert (bufferFlushWhenCachingData || this.triggerFlushInterval > 0L);
        this.scheduledExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"checkResource");
        this.scheduledExecutorService.scheduleAtFixedRate(this::preAllocatedBufferCheck, this.preAllocationExpired / 2L, this.preAllocationExpired / 2L, TimeUnit.MILLISECONDS);
        this.expiredAppCleanupExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"expiredAppCleaner");
        this.expiredAppCleanupExecutorService.scheduleAtFixedRate(this::checkResourceStatus, this.appExpiredWithoutHB / 2L, this.appExpiredWithoutHB / 2L, TimeUnit.MILLISECONDS);
        this.leakShuffleDataCheckExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"leakShuffleDataChecker");
        this.leakShuffleDataCheckExecutorService.scheduleAtFixedRate(this::checkLeakShuffleData, this.leakShuffleDataCheckInterval, this.leakShuffleDataCheckInterval, TimeUnit.MILLISECONDS);
        if (this.triggerFlushInterval > 0L) {
            this.triggerFlushExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"triggerShuffleBufferManagerFlush");
            this.triggerFlushExecutorService.scheduleWithFixedDelay(this::triggerFlush, this.triggerFlushInterval / 2L, this.triggerFlushInterval, TimeUnit.MILLISECONDS);
        }
        if (shuffleBufferManager != null) {
            shuffleBufferManager.setShuffleTaskManager(this);
        }
        this.shuffleBlockIdManager = ShuffleBlockIdManagerFactory.createShuffleBlockIdManager(conf);
        this.appLocks = CacheBuilder.newBuilder().expireAfterAccess(3600L, TimeUnit.SECONDS).maximumSize(Integer.MAX_VALUE).build();
        Runnable clearResourceRunnable = () -> {
            while (true) {
                PurgeEvent event = null;
                try {
                    double usedTime;
                    event = this.expiredAppIdQueue.take();
                    long startTime = System.currentTimeMillis();
                    if (event instanceof AppPurgeEvent) {
                        this.removeResources(event.getAppId(), true);
                        usedTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                        ShuffleServerMetrics.summaryTotalRemoveResourceTime.observe(usedTime);
                    }
                    if (event instanceof AppUnregisterPurgeEvent) {
                        this.removeResources(event.getAppId(), false);
                        usedTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                        ShuffleServerMetrics.summaryTotalRemoveResourceTime.observe(usedTime);
                    }
                    if (!(event instanceof ShufflePurgeEvent)) continue;
                    this.removeResourcesByShuffleIds(event.getAppId(), event.getShuffleIds());
                    usedTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                    ShuffleServerMetrics.summaryTotalRemoveResourceByShuffleIdsTime.observe(usedTime);
                    continue;
                }
                catch (Exception e) {
                    StringBuilder diagnosticMessageBuilder = new StringBuilder("Exception happened when clearing resource for expired application");
                    if (event != null) {
                        diagnosticMessageBuilder.append(" for appId: ");
                        diagnosticMessageBuilder.append(event.getAppId());
                        if (CollectionUtils.isNotEmpty(event.getShuffleIds())) {
                            diagnosticMessageBuilder.append(", shuffleIds: ");
                            diagnosticMessageBuilder.append(event.getShuffleIds());
                        }
                    }
                    LOG.error("{}", (Object)diagnosticMessageBuilder, (Object)e);
                    continue;
                }
                break;
            }
        };
        this.clearResourceThread = new Thread(clearResourceRunnable);
        this.clearResourceThread.setName("clearResourceThread");
        this.clearResourceThread.setDaemon(true);
        this.topNShuffleDataSizeOfAppCalcTask = new TopNShuffleDataSizeOfAppCalcTask(this, conf);
        this.topNShuffleDataSizeOfAppCalcTask.start();
        ShuffleServerMetrics.addLabeledGauge("require_buffer_count", this.requireBufferIds::size);
        ShuffleServerMetrics.addLabeledCacheGauge("reported_block_count", () -> this.shuffleBlockIdManager.getTotalBlockCount() + this.shuffleTaskInfos.values().stream().map(ShuffleTaskInfo::getShuffleBlockIdManager).filter(manager -> manager != null && manager != this.shuffleBlockIdManager).mapToLong(ShuffleBlockIdManager::getTotalBlockCount).sum(), 120000L);
        ShuffleServerMetrics.addLabeledCacheGauge("cached_block_count", () -> this.shuffleTaskInfos.values().stream().map(ShuffleTaskInfo::getCachedBlockIds).flatMap(map -> map.values().stream()).mapToLong(Roaring64NavigableMap::getLongCardinality).sum(), 120000L);
    }

    public ReentrantReadWriteLock.WriteLock getAppWriteLock(String appId) {
        try {
            return this.appLocks.get(appId, ReentrantReadWriteLock::new).writeLock();
        }
        catch (ExecutionException e) {
            LOG.error("Failed to get App lock.", (Throwable)e);
            throw new RssException((Throwable)e);
        }
    }

    public ReentrantReadWriteLock.ReadLock getAppReadLock(String appId) {
        try {
            return this.appLocks.get(appId, ReentrantReadWriteLock::new).readLock();
        }
        catch (ExecutionException e) {
            LOG.error("Failed to get App lock.", (Throwable)e);
            throw new RssException((Throwable)e);
        }
    }

    @VisibleForTesting
    public StatusCode registerShuffle(String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorageInfo, String user) {
        return this.registerShuffle(appId, shuffleId, partitionRanges, remoteStorageInfo, user, ShuffleDataDistributionType.NORMAL, -1, Collections.emptyMap());
    }

    public StatusCode registerShuffle(String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorageInfo, String user, ShuffleDataDistributionType dataDistType, int maxConcurrencyPerPartitionToWrite, Map<String, String> properties) {
        if (this.isAppRemoving(appId)) {
            return StatusCode.INVALID_REQUEST;
        }
        this.refreshAppId(appId);
        ShuffleTaskInfo taskInfo = this.shuffleTaskInfos.get(appId);
        taskInfo.setProperties(properties);
        taskInfo.setUser(user);
        taskInfo.setSpecification(ShuffleSpecification.builder().maxConcurrencyPerPartitionToWrite(ShuffleTaskManager.getMaxConcurrencyWriting(maxConcurrencyPerPartitionToWrite, this.conf)).dataDistributionType(dataDistType).build());
        taskInfo.setShuffleBlockIdManagerIfNeeded(this.shuffleBlockIdManager);
        taskInfo.getShuffleBlockIdManager().registerAppId(appId);
        for (PartitionRange partitionRange : partitionRanges) {
            this.shuffleBufferManager.registerBuffer(appId, shuffleId, partitionRange.getStart(), partitionRange.getEnd());
        }
        if (!remoteStorageInfo.isEmpty()) {
            this.storageManager.registerRemoteStorage(appId, remoteStorageInfo);
        }
        return StatusCode.SUCCESS;
    }

    @VisibleForTesting
    protected static int getMaxConcurrencyWriting(int maxConcurrencyPerPartitionToWrite, ShuffleServerConf conf) {
        if (maxConcurrencyPerPartitionToWrite > 0) {
            return Math.min(maxConcurrencyPerPartitionToWrite, (Integer)conf.get(ShuffleServerConf.CLIENT_MAX_CONCURRENCY_LIMITATION_OF_ONE_PARTITION));
        }
        return (Integer)conf.get(ShuffleServerConf.SERVER_MAX_CONCURRENCY_OF_ONE_PARTITION);
    }

    public StatusCode cacheShuffleData(String appId, int shuffleId, boolean isPreAllocated, ShufflePartitionedData spd) {
        this.refreshAppId(appId);
        long partitionSize = this.getPartitionDataSize(appId, shuffleId, spd.getPartitionId());
        long deltaSize = spd.getTotalBlockEncodedLength();
        HugePartitionUtils.checkExceedPartitionHardLimit("cacheShuffleData", this.shuffleBufferManager, partitionSize += deltaSize, deltaSize);
        return this.shuffleBufferManager.cacheShuffleData(appId, shuffleId, isPreAllocated, spd);
    }

    public PreAllocatedBufferInfo getAndRemovePreAllocatedBuffer(long requireBufferId) {
        return this.requireBufferIds.remove(requireBufferId);
    }

    public void releasePreAllocatedSize(long requireSize) {
        this.shuffleBufferManager.releasePreAllocatedSize(requireSize);
    }

    @VisibleForTesting
    void removeAndReleasePreAllocatedBuffer(long requireBufferId) {
        PreAllocatedBufferInfo info = this.getAndRemovePreAllocatedBuffer(requireBufferId);
        if (info != null) {
            this.releasePreAllocatedSize(info.getRequireSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCode commitShuffle(String appId, int shuffleId) throws Exception {
        Object lock;
        long start = System.currentTimeMillis();
        this.refreshAppId(appId);
        Roaring64NavigableMap cachedBlockIds = this.getCachedBlockIds(appId, shuffleId);
        ShuffleTaskInfo shuffleTaskInfo = this.shuffleTaskInfos.computeIfAbsent(appId, x -> new ShuffleTaskInfo(appId));
        Object object = lock = shuffleTaskInfo.getCommitLocks().computeIfAbsent(shuffleId, x -> new Object());
        synchronized (object) {
            Roaring64NavigableMap cloneBlockIds;
            long commitTimeout = (Long)this.conf.get(ShuffleServerConf.SERVER_COMMIT_TIMEOUT);
            if (System.currentTimeMillis() - start > commitTimeout) {
                throw new RssException("Shuffle data commit timeout for " + commitTimeout + " ms");
            }
            Roaring64NavigableMap roaring64NavigableMap = cachedBlockIds;
            synchronized (roaring64NavigableMap) {
                cloneBlockIds = RssUtils.cloneBitMap((Roaring64NavigableMap)cachedBlockIds);
            }
            long expectedCommitted = cloneBlockIds.getLongCardinality();
            this.shuffleBufferManager.commitShuffleTask(appId, shuffleId);
            long checkInterval = 1000L;
            while (true) {
                Roaring64NavigableMap cloneCommittedBlockIds;
                Roaring64NavigableMap committedBlockIds;
                Roaring64NavigableMap roaring64NavigableMap2 = committedBlockIds = this.shuffleFlushManager.getCommittedBlockIds(appId, shuffleId);
                synchronized (roaring64NavigableMap2) {
                    cloneCommittedBlockIds = RssUtils.cloneBitMap((Roaring64NavigableMap)committedBlockIds);
                }
                cloneBlockIds.andNot(cloneCommittedBlockIds);
                if (cloneBlockIds.isEmpty()) break;
                Thread.sleep(checkInterval);
                if (System.currentTimeMillis() - start > commitTimeout) {
                    throw new RssException("Shuffle data commit timeout for " + commitTimeout + " ms");
                }
                LOG.info("Checking commit result for appId[" + appId + "], shuffleId[" + shuffleId + "], expect committed[" + expectedCommitted + "], remain[" + cloneBlockIds.getLongCardinality() + "]");
                checkInterval = Math.min(checkInterval * 2L, this.commitCheckIntervalMax);
            }
            LOG.info("Finish commit for appId[" + appId + "], shuffleId[" + shuffleId + "] with expectedCommitted[" + expectedCommitted + "], cost " + (System.currentTimeMillis() - start) + " ms to check");
        }
        return StatusCode.SUCCESS;
    }

    public int addFinishedBlockIds(String appId, Integer shuffleId, Map<Integer, long[]> partitionToBlockIds, int bitmapNum) {
        this.refreshAppId(appId);
        ShuffleTaskInfo taskInfo = this.getShuffleTaskInfo(appId);
        if (taskInfo == null) {
            throw new InvalidRequestException("ShuffleTaskInfo is not found that should not happen for appId: " + appId);
        }
        ShuffleBlockIdManager manager = taskInfo.getShuffleBlockIdManager();
        if (manager == null) {
            throw new RssException("appId[" + appId + "] is expired!");
        }
        return manager.addFinishedBlockIds(taskInfo, appId, shuffleId, partitionToBlockIds, bitmapNum);
    }

    public int updateAndGetCommitCount(String appId, int shuffleId) {
        ShuffleTaskInfo shuffleTaskInfo = this.shuffleTaskInfos.computeIfAbsent(appId, x -> new ShuffleTaskInfo(appId));
        AtomicInteger commitNum = shuffleTaskInfo.getCommitCounts().computeIfAbsent(shuffleId, x -> new AtomicInteger(0));
        return commitNum.incrementAndGet();
    }

    public void updateCachedBlockIds(String appId, int shuffleId, ShufflePartitionedBlock[] spbs) {
        this.updateCachedBlockIds(appId, shuffleId, 0, spbs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCachedBlockIds(String appId, int shuffleId, int partitionId, ShufflePartitionedBlock[] spbs) {
        if (spbs == null || ((ShufflePartitionedBlock[])spbs).length == 0) {
            return;
        }
        ShuffleTaskInfo shuffleTaskInfo = this.shuffleTaskInfos.computeIfAbsent(appId, x -> new ShuffleTaskInfo(appId));
        long size = 0L;
        if (!this.storageTypeWithMemory) {
            Roaring64NavigableMap bitmap;
            Roaring64NavigableMap roaring64NavigableMap = bitmap = shuffleTaskInfo.getCachedBlockIds().computeIfAbsent(shuffleId, x -> Roaring64NavigableMap.bitmapOf((long[])new long[0]));
            synchronized (roaring64NavigableMap) {
                for (Roaring64NavigableMap spb : spbs) {
                    bitmap.addLong(spb.getBlockId());
                    size += spb.getEncodedLength();
                }
            }
        } else {
            for (Roaring64NavigableMap spb : spbs) {
                size += spb.getEncodedLength();
            }
        }
        long partitionSize = shuffleTaskInfo.addPartitionDataSize(shuffleId, partitionId, size);
        HugePartitionUtils.markHugePartition(this.shuffleBufferManager, shuffleTaskInfo, shuffleId, partitionId, partitionSize);
    }

    public Roaring64NavigableMap getCachedBlockIds(String appId, int shuffleId) {
        Map<Integer, Roaring64NavigableMap> shuffleIdToBlockIds = this.shuffleTaskInfos.getOrDefault(appId, new ShuffleTaskInfo(appId)).getCachedBlockIds();
        Roaring64NavigableMap blockIds = shuffleIdToBlockIds.get(shuffleId);
        if (blockIds == null) {
            LOG.warn("Unexpected value when getCachedBlockIds for appId[" + appId + "], shuffleId[" + shuffleId + "]");
            return Roaring64NavigableMap.bitmapOf((long[])new long[0]);
        }
        return blockIds;
    }

    public long getPartitionDataSize(String appId, int shuffleId, int partitionId) {
        ShuffleTaskInfo shuffleTaskInfo = this.shuffleTaskInfos.get(appId);
        if (shuffleTaskInfo == null) {
            return 0L;
        }
        return shuffleTaskInfo.getPartitionDataSize(shuffleId, partitionId);
    }

    public Pair<Long, List<Integer>> requireBufferReturnPair(String appId, int shuffleId, List<Integer> partitionIds, List<Integer> partitionRequireSizes, int requireSize) {
        ShuffleTaskInfo shuffleTaskInfo = this.shuffleTaskInfos.get(appId);
        if (null == shuffleTaskInfo) {
            LOG.error("No such app is registered. appId: {}, shuffleId: {}", (Object)appId, (Object)shuffleId);
            throw new NoRegisterException("No such app is registered. appId: " + appId);
        }
        ArrayList<Integer> splitPartitionIds = new ArrayList<Integer>();
        if (partitionIds.size() == partitionRequireSizes.size()) {
            for (int i = 0; i < partitionIds.size(); ++i) {
                int partitionId = partitionIds.get(i);
                int partitionRequireSize = partitionRequireSizes.get(i);
                long partitionUsedDataSize = this.getPartitionDataSize(appId, shuffleId, partitionId) + (long)partitionRequireSize;
                if (HugePartitionUtils.limitHugePartition(this.shuffleBufferManager, appId, shuffleId, partitionId, partitionUsedDataSize)) {
                    String errorMessage = String.format("Huge partition is limited to writing. appId: %s, shuffleId: %s, partitionIds: %s, partitionUsedDataSize: %s", appId, shuffleId, OutputUtils.listToSegment(partitionIds, (long)10L), partitionUsedDataSize);
                    LOG.error(errorMessage);
                    throw new NoBufferForHugePartitionException(errorMessage);
                }
                HugePartitionUtils.checkExceedPartitionHardLimit("requireBuffer", this.shuffleBufferManager, partitionUsedDataSize, partitionRequireSize);
                if (!HugePartitionUtils.hasExceedPartitionSplitLimit(this.shuffleBufferManager, partitionUsedDataSize)) continue;
                LOG.info("Need split partition. appId: {}, shuffleId: {}, partitionIds: {}, partitionUsedDataSize: {}", new Object[]{appId, shuffleId, partitionIds, partitionUsedDataSize});
                splitPartitionIds.add(partitionId);
            }
        }
        return Pair.of((Object)this.requireBuffer(appId, requireSize), splitPartitionIds);
    }

    @VisibleForTesting
    public long requireBuffer(String appId, int shuffleId, List<Integer> partitionIds, List<Integer> partitionRequireSizes, int requireSize) {
        return (Long)this.requireBufferReturnPair(appId, shuffleId, partitionIds, partitionRequireSizes, requireSize).getLeft();
    }

    public long requireBuffer(String appId, int requireSize) {
        if (this.shuffleBufferManager.requireMemory(requireSize, true)) {
            long requireId = this.requireBufferId.incrementAndGet();
            this.requireBufferIds.put(requireId, new PreAllocatedBufferInfo(appId, requireId, System.currentTimeMillis(), requireSize));
            return requireId;
        }
        LOG.warn("Failed to require buffer, require size: {}", (Object)requireSize);
        throw new NoBufferException("No Buffer For Regular Partition, requireSize: " + requireSize);
    }

    public long requireBuffer(int requireSize) {
        return this.requireBuffer("EMPTY", requireSize);
    }

    public boolean requireMemory(int requireSize, boolean isPreAllocated) {
        return this.shuffleBufferManager.requireMemory(requireSize, isPreAllocated);
    }

    public void releaseMemory(int requireSize, boolean isReleaseFlushMemory, boolean isReleasePreAllocation) {
        this.shuffleBufferManager.releaseMemory(requireSize, isReleaseFlushMemory, isReleasePreAllocation);
    }

    public byte[] getFinishedBlockIds(String appId, Integer shuffleId, Set<Integer> partitions, BlockIdLayout blockIdLayout) throws IOException {
        this.refreshAppId(appId);
        for (int partitionId : partitions) {
            Map.Entry<Range<Integer>, ShuffleBuffer> entry = this.shuffleBufferManager.getShuffleBufferEntry(appId, shuffleId, partitionId);
            if (entry == null) {
                LOG.error("The empty shuffle buffer, this should not happen. appId: {}, shuffleId: {}, partition: {}, layout: {}", new Object[]{appId, shuffleId, partitionId, blockIdLayout});
                continue;
            }
            Storage storage = this.storageManager.selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, entry.getKey().lowerEndpoint()));
            if (storage == null) continue;
            storage.updateReadMetrics(new StorageReadMetrics(appId, shuffleId.intValue()));
        }
        ShuffleTaskInfo taskInfo = this.getShuffleTaskInfo(appId);
        ShuffleBlockIdManager manager = taskInfo.getShuffleBlockIdManager();
        if (manager == null) {
            throw new RssException("appId[" + appId + "] is expired!");
        }
        return manager.getFinishedBlockIds(taskInfo, appId, shuffleId, partitions, blockIdLayout);
    }

    public ShuffleDataResult getInMemoryShuffleData(String appId, Integer shuffleId, Integer partitionId, long blockId, int readBufferSize, Roaring64NavigableMap expectedTaskIds) {
        this.refreshAppId(appId);
        return this.shuffleBufferManager.getShuffleData(appId, shuffleId, partitionId, blockId, readBufferSize, expectedTaskIds);
    }

    public ShuffleDataResult getShuffleData(String appId, Integer shuffleId, Integer partitionId, int partitionNumPerRange, int partitionNum, String storageType, long offset, int length, int storageId) {
        this.refreshAppId(appId);
        CreateShuffleReadHandlerRequest request = new CreateShuffleReadHandlerRequest();
        request.setAppId(appId);
        request.setShuffleId(shuffleId.intValue());
        request.setPartitionId(partitionId.intValue());
        request.setPartitionNumPerRange(partitionNumPerRange);
        request.setPartitionNum(partitionNum);
        request.setStorageType(storageType);
        request.setRssBaseConf((RssBaseConf)this.conf);
        int[] range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
        Storage storage = this.storageManager.selectStorage(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0], storageId));
        if (storage == null) {
            throw new FileNotFoundException("No such data stored in current storage manager.");
        }
        try {
            return storage.getOrCreateReadHandler(request).getShuffleData(offset, length);
        }
        catch (FileNotFoundException e) {
            LOG.warn("shuffle file not found {}-{}-{} in {}", new Object[]{appId, shuffleId, partitionId, storage.getStoragePath(), e});
            throw e;
        }
    }

    public ShuffleIndexResult getShuffleIndex(String appId, Integer shuffleId, Integer partitionId, int partitionNumPerRange, int partitionNum) {
        this.refreshAppId(appId);
        String storageType = ((StorageType)this.conf.get(RssBaseConf.RSS_STORAGE_TYPE)).name();
        CreateShuffleReadHandlerRequest request = new CreateShuffleReadHandlerRequest();
        request.setAppId(appId);
        request.setShuffleId(shuffleId.intValue());
        request.setPartitionId(partitionId.intValue());
        request.setPartitionNumPerRange(partitionNumPerRange);
        request.setPartitionNum(partitionNum);
        request.setStorageType(storageType);
        request.setRssBaseConf((RssBaseConf)this.conf);
        int[] range = ShuffleStorageUtils.getPartitionRange((int)partitionId, (int)partitionNumPerRange, (int)partitionNum);
        Storage storage = this.storageManager.selectStorageById(new ShuffleDataReadEvent(appId, shuffleId, partitionId, range[0]));
        if (storage == null) {
            throw new FileNotFoundException("No such data in current storage manager.");
        }
        ShuffleIndexResult result = storage.getOrCreateReadHandler(request).getShuffleIndex();
        if (result == null) {
            throw new FileNotFoundException("No such data in current storage manager.");
        }
        return result;
    }

    public void checkResourceStatus() {
        try {
            HashSet<String> appNames = Sets.newHashSet(this.shuffleTaskInfos.keySet());
            for (String appId : appNames) {
                if (!this.isAppExpired(appId)) continue;
                LOG.info("Detect expired appId[" + appId + "] according to rss.server.app.expired.withoutHeartbeat");
                this.expiredAppIdQueue.add(new AppPurgeEvent(appId, this.getUserByAppId(appId)));
            }
            ShuffleServerMetrics.gaugeAppNum.set((double)this.shuffleTaskInfos.size());
        }
        catch (Exception e) {
            LOG.warn("Error happened in checkResourceStatus", (Throwable)e);
        }
    }

    public boolean isAppExpired(String appId) {
        ShuffleTaskInfo shuffleTaskInfo = this.shuffleTaskInfos.get(appId);
        if (shuffleTaskInfo == null) {
            return true;
        }
        return System.currentTimeMillis() - shuffleTaskInfo.getCurrentTimes() > this.appExpiredWithoutHB;
    }

    public boolean isAppRemoving(String appId) {
        return this.removingApps.containsKey(appId);
    }

    public void removeResourcesByShuffleIds(String appId, List<Integer> shuffleIds) {
        this.removeResourcesByShuffleIds(appId, shuffleIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourcesByShuffleIds(String appId, List<Integer> shuffleIds, boolean isRenameAndDelete) {
        ReentrantReadWriteLock.WriteLock writeLock = this.getAppWriteLock(appId);
        writeLock.lock();
        try {
            if (CollectionUtils.isEmpty(shuffleIds)) {
                return;
            }
            LOG.info("Start remove resource for appId[{}], shuffleIds[{}]", (Object)appId, shuffleIds);
            long start = System.currentTimeMillis();
            ShuffleTaskInfo taskInfo = this.shuffleTaskInfos.get(appId);
            if (taskInfo != null) {
                for (Integer shuffleId : shuffleIds) {
                    taskInfo.getCachedBlockIds().remove(shuffleId);
                    taskInfo.getCommitCounts().remove(shuffleId);
                    taskInfo.getCommitLocks().remove(shuffleId);
                }
                ShuffleBlockIdManager manager = taskInfo.getShuffleBlockIdManager();
                if (manager == null) {
                    throw new RssException("appId[" + appId + "] is expired!");
                }
                manager.removeBlockIdByShuffleId(appId, shuffleIds);
            } else {
                this.shuffleBlockIdManager.removeBlockIdByShuffleId(appId, shuffleIds);
            }
            this.shuffleBufferManager.removeBufferByShuffleId(appId, shuffleIds);
            this.shuffleFlushManager.removeResourcesOfShuffleId(appId, shuffleIds);
            String operationMsg = String.format("removing storage data for appId:%s, shuffleIds:%s", appId, shuffleIds);
            this.withTimeoutExecution(() -> {
                this.storageManager.removeResources(new ShufflePurgeEvent(appId, this.getUserByAppId(appId), shuffleIds, isRenameAndDelete));
                return null;
            }, this.storageRemoveOperationTimeoutSec, operationMsg);
            if (this.shuffleMergeManager != null) {
                this.shuffleMergeManager.removeBuffer(appId, shuffleIds);
            }
            LOG.info("Finish remove resource for appId[{}], shuffleIds[{}], cost[{}]", new Object[]{appId, shuffleIds, System.currentTimeMillis() - start});
        }
        finally {
            writeLock.unlock();
        }
    }

    public void checkLeakShuffleData() {
        LOG.info("Start check leak shuffle data");
        try {
            this.storageManager.checkAndClearLeakedShuffleData(() -> Sets.newHashSet(this.shuffleTaskInfos.keySet()));
            LOG.info("Finish check leak shuffle data");
        }
        catch (Exception e) {
            LOG.warn("Error happened in checkLeakShuffleData", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void removeResources(String appId, boolean checkAppExpired) {
        ReentrantReadWriteLock.WriteLock lock = this.getAppWriteLock(appId);
        lock.lock();
        try {
            LOG.info("Start remove resource for appId[" + appId + "]");
            if (checkAppExpired && !this.isAppExpired(appId)) {
                LOG.info("It seems that this appId[{}] has registered a new shuffle, just ignore this AppPurgeEvent event.", (Object)appId);
                return;
            }
            long start = System.currentTimeMillis();
            this.removingApps.put(appId, start);
            ShuffleTaskInfo shuffleTaskInfo = this.shuffleTaskInfos.remove(appId);
            if (shuffleTaskInfo == null) {
                LOG.info("Resource for appId[" + appId + "] had been removed before.");
                return;
            }
            LOG.info("Dump Removing app summary of {}", (Object)appId);
            StringBuilder partitionInfoSummary = new StringBuilder();
            partitionInfoSummary.append("appId: ").append(appId).append("\n");
            for (int shuffleId : shuffleTaskInfo.getShuffleIds()) {
                if (!this.conf.getBoolean(ShuffleServerConf.SERVER_LOG_APP_DETAIL_WHILE_REMOVE_ENABLED)) continue;
                for (int partitionId : shuffleTaskInfo.getPartitionIds(shuffleId)) {
                    long partitionSize = shuffleTaskInfo.getPartitionDataSize(shuffleId, partitionId);
                    long partitionBlockCount = shuffleTaskInfo.getBlockNumber(shuffleId, partitionId);
                    LOG.info("shufflePartitionInfo(blockCount/size): {}-{}-{}: {}/{}", new Object[]{appId, shuffleId, partitionId, partitionBlockCount, UnitConverter.formatSize((long)partitionSize)});
                }
            }
            partitionInfoSummary.append("The app task info: ").append(shuffleTaskInfo);
            LOG.info("Removing app summary info: {}", (Object)partitionInfoSummary);
            ShuffleBlockIdManager manager = shuffleTaskInfo.getShuffleBlockIdManager();
            if (manager != null) {
                manager.removeBlockIdByAppId(appId);
            }
            this.shuffleBlockIdManager.removeBlockIdByAppId(appId);
            this.shuffleBufferManager.removeBuffer(appId);
            this.shuffleFlushManager.removeResources(appId);
            String operationMsg = String.format("removing storage data for appId:%s", appId);
            this.withTimeoutExecution(() -> {
                this.storageManager.removeResources(new AppPurgeEvent(appId, shuffleTaskInfo.getUser(), new ArrayList<Integer>(shuffleTaskInfo.getShuffleIds()), checkAppExpired));
                return null;
            }, this.storageRemoveOperationTimeoutSec, operationMsg);
            if (this.shuffleMergeManager != null) {
                this.shuffleMergeManager.removeBuffer(appId);
            }
            if (shuffleTaskInfo.hasHugePartition()) {
                ShuffleServerMetrics.gaugeAppWithHugePartitionNum.dec();
                ShuffleServerMetrics.gaugeHugePartitionNum.dec();
            }
            LOG.info("Finish remove resource for appId[" + appId + "] cost " + (System.currentTimeMillis() - start) + " ms");
        }
        finally {
            this.removingApps.remove(appId);
            lock.unlock();
        }
    }

    private void withTimeoutExecution(Supplier supplier, long timeoutSec, String operationDetailedMsg) {
        block3: {
            CompletableFuture future = CompletableFuture.supplyAsync(supplier, Executors.newSingleThreadExecutor());
            CompletableFuture extended = CompletableFutureExtension.orTimeout(future, (long)timeoutSec, (TimeUnit)TimeUnit.SECONDS);
            try {
                extended.get();
            }
            catch (Exception e) {
                if (!(e instanceof ExecutionException)) break block3;
                if (e.getCause() instanceof TimeoutException) {
                    LOG.error("Errors on finishing operation of [{}] in the {}(sec). This should not happen!", (Object)operationDetailedMsg, (Object)timeoutSec);
                    return;
                }
                throw new RssException((Throwable)e);
            }
        }
    }

    public void refreshAppId(String appId) {
        this.shuffleTaskInfos.computeIfAbsent(appId, x -> {
            ShuffleServerMetrics.counterTotalAppNum.inc();
            return new ShuffleTaskInfo(appId);
        }).setCurrentTimes(System.currentTimeMillis());
    }

    private void preAllocatedBufferCheck() {
        try {
            long current = System.currentTimeMillis();
            ArrayList<Long> removeIds = Lists.newArrayList();
            for (PreAllocatedBufferInfo info : this.requireBufferIds.values()) {
                if (current - info.getTimestamp() <= this.preAllocationExpired) continue;
                removeIds.add(info.getRequireId());
            }
            for (Long requireId : removeIds) {
                PreAllocatedBufferInfo info = this.requireBufferIds.remove(requireId);
                if (info != null) {
                    this.shuffleBufferManager.releaseMemory(info.getRequireSize(), false, true);
                    LOG.warn("Remove expired preAllocatedBuffer[id={}] that required by app: {}", (Object)requireId, (Object)info.getAppId());
                    ShuffleServerMetrics.counterPreAllocatedBufferExpired.inc();
                    continue;
                }
                LOG.info("PreAllocatedBuffer[id={}] has already be used", (Object)requireId);
            }
        }
        catch (Exception e) {
            LOG.warn("Error happened in preAllocatedBufferCheck", (Throwable)e);
        }
    }

    public int getRequireBufferSize(long requireId) {
        PreAllocatedBufferInfo pabi = this.requireBufferIds.get(requireId);
        if (pabi == null) {
            return 0;
        }
        return pabi.getRequireSize();
    }

    public String getUserByAppId(String appId) {
        return this.shuffleTaskInfos.computeIfAbsent(appId, x -> new ShuffleTaskInfo(appId)).getUser();
    }

    @VisibleForTesting
    public Set<String> getAppIds() {
        return this.shuffleTaskInfos.keySet();
    }

    @VisibleForTesting
    Map<Long, PreAllocatedBufferInfo> getRequireBufferIds() {
        return this.requireBufferIds;
    }

    public void removeShuffleDataAsync(String appId, int shuffleId) {
        this.expiredAppIdQueue.add(new ShufflePurgeEvent(appId, this.getUserByAppId(appId), Arrays.asList(shuffleId)));
    }

    public void removeShuffleDataAsync(String appId) {
        this.expiredAppIdQueue.add(new AppUnregisterPurgeEvent(appId, this.getUserByAppId(appId)));
    }

    @VisibleForTesting
    public void removeShuffleDataSync(String appId, int shuffleId) {
        this.removeResourcesByShuffleIds(appId, Arrays.asList(shuffleId));
    }

    public void removeShuffleDataSyncRenameAndDelete(String appId, int shuffleId) {
        this.removeResourcesByShuffleIds(appId, Arrays.asList(shuffleId), true);
    }

    public ShuffleDataDistributionType getDataDistributionType(String appId) {
        return this.shuffleTaskInfos.get(appId).getDataDistType();
    }

    @VisibleForTesting
    public ShuffleTaskInfo getShuffleTaskInfo(String appId) {
        return this.shuffleTaskInfos.get(appId);
    }

    private void triggerFlush() {
        if (this.shuffleBufferManager.needToFlush()) {
            this.shuffleBufferManager.flushIfNecessary();
        }
    }

    public Map<String, ShuffleTaskInfo> getShuffleTaskInfos() {
        return this.shuffleTaskInfos;
    }

    public void stop() {
        this.topNShuffleDataSizeOfAppCalcTask.stop();
    }

    public void start() {
        this.clearResourceThread.start();
    }

    @VisibleForTesting
    protected void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @VisibleForTesting
    protected void setShuffleFlushManager(ShuffleFlushManager flushManager) {
        this.shuffleFlushManager = flushManager;
    }

    @VisibleForTesting
    public ShuffleBlockIdManager getShuffleBlockIdManager() {
        return this.shuffleBlockIdManager;
    }
}

