/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl.grpc;

import io.grpc.StatusRuntimeException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uniffle.client.api.ClientInfo;
import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.common.ShuffleServerPushCostTracker;
import org.apache.uniffle.client.impl.grpc.GrpcClient;
import org.apache.uniffle.client.request.RetryableRequest;
import org.apache.uniffle.client.request.RssAppHeartBeatRequest;
import org.apache.uniffle.client.request.RssFinishShuffleRequest;
import org.apache.uniffle.client.request.RssGetInMemoryShuffleDataRequest;
import org.apache.uniffle.client.request.RssGetShuffleDataRequest;
import org.apache.uniffle.client.request.RssGetShuffleIndexRequest;
import org.apache.uniffle.client.request.RssGetShuffleResultForMultiPartRequest;
import org.apache.uniffle.client.request.RssGetShuffleResultRequest;
import org.apache.uniffle.client.request.RssGetSortedShuffleDataRequest;
import org.apache.uniffle.client.request.RssRegisterShuffleRequest;
import org.apache.uniffle.client.request.RssReportShuffleResultRequest;
import org.apache.uniffle.client.request.RssSendCommitRequest;
import org.apache.uniffle.client.request.RssSendShuffleDataRequest;
import org.apache.uniffle.client.request.RssStartSortMergeRequest;
import org.apache.uniffle.client.request.RssUnregisterShuffleByAppIdRequest;
import org.apache.uniffle.client.request.RssUnregisterShuffleRequest;
import org.apache.uniffle.client.response.RssAppHeartBeatResponse;
import org.apache.uniffle.client.response.RssFinishShuffleResponse;
import org.apache.uniffle.client.response.RssGetInMemoryShuffleDataResponse;
import org.apache.uniffle.client.response.RssGetShuffleDataResponse;
import org.apache.uniffle.client.response.RssGetShuffleIndexResponse;
import org.apache.uniffle.client.response.RssGetShuffleResultResponse;
import org.apache.uniffle.client.response.RssGetSortedShuffleDataResponse;
import org.apache.uniffle.client.response.RssRegisterShuffleResponse;
import org.apache.uniffle.client.response.RssReportShuffleResultResponse;
import org.apache.uniffle.client.response.RssSendCommitResponse;
import org.apache.uniffle.client.response.RssSendShuffleDataResponse;
import org.apache.uniffle.client.response.RssStartSortMergeResponse;
import org.apache.uniffle.client.response.RssUnregisterShuffleByAppIdResponse;
import org.apache.uniffle.client.response.RssUnregisterShuffleResponse;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.NotRetryException;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.OutputUtils;
import org.apache.uniffle.common.util.RetryUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.proto.ShuffleServerGrpc;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.apache.uniffle.shaded.com.google.protobuf.ByteString;
import org.apache.uniffle.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleServerGrpcClient
extends GrpcClient
implements ShuffleServerClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleServerGrpcClient.class);
    protected static final long FAILED_REQUIRE_ID = -1L;
    protected long rpcTimeout;
    private ShuffleServerGrpc.ShuffleServerBlockingStub blockingStub;
    protected Random random = new Random();
    protected static final int BACK_OFF_BASE = 2000;
    static final List<StatusCode> NOT_RETRY_STATUS_CODES = Lists.newArrayList(StatusCode.NO_REGISTER, StatusCode.APP_NOT_FOUND, StatusCode.INTERNAL_NOT_RETRY_ERROR, StatusCode.EXCEED_HUGE_PARTITION_HARD_LIMIT);
    private ShuffleServerInfo serverInfo;

    @VisibleForTesting
    public ShuffleServerGrpcClient(String host, int port) {
        this(host, port, RssClientConf.RPC_MAX_ATTEMPTS.defaultValue(), RssClientConf.RPC_TIMEOUT_MS.defaultValue(), true, 0, 0, 0, -1);
    }

    public ShuffleServerGrpcClient(RssConf rssConf, ShuffleServerInfo rssServerInfo) {
        this(rssConf, rssServerInfo.getHost(), rssServerInfo.getGrpcPort());
        this.serverInfo = rssServerInfo;
    }

    public ShuffleServerGrpcClient(RssConf rssConf, String host, int port) {
        this(host, port, rssConf == null ? RssClientConf.RPC_MAX_ATTEMPTS.defaultValue().intValue() : rssConf.getInteger(RssClientConf.RPC_MAX_ATTEMPTS), rssConf == null ? RssClientConf.RPC_TIMEOUT_MS.defaultValue().longValue() : rssConf.getLong(RssClientConf.RPC_TIMEOUT_MS), true, 0, 0, 0, rssConf == null ? -1 : rssConf.get(RssClientConf.RSS_CLIENT_GRPC_EVENT_LOOP_THREADS));
    }

    public ShuffleServerGrpcClient(String host, int port, int maxRetryAttempts, long rpcTimeoutMs, boolean usePlaintext, int pageSize, int maxOrder, int smallCacheSize, int nettyEventLoopThreads) {
        super(host, port, maxRetryAttempts, usePlaintext, pageSize, maxOrder, smallCacheSize, nettyEventLoopThreads);
        this.blockingStub = ShuffleServerGrpc.newBlockingStub(this.channel);
        this.rpcTimeout = rpcTimeoutMs;
    }

    public ShuffleServerGrpc.ShuffleServerBlockingStub getBlockingStub() {
        return (ShuffleServerGrpc.ShuffleServerBlockingStub)this.blockingStub.withDeadlineAfter(this.rpcTimeout, TimeUnit.MILLISECONDS);
    }

    private RssProtos.ShuffleRegisterResponse doRegisterShuffle(String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorageInfo, String user, ShuffleDataDistributionType dataDistributionType, int maxConcurrencyPerPartitionToWrite, RssProtos.MergeContext mergeContext, Map<String, String> properties) {
        RssProtos.ShuffleRegisterRequest.Builder reqBuilder = RssProtos.ShuffleRegisterRequest.newBuilder();
        reqBuilder.setAppId(appId).setShuffleId(shuffleId).setUser(user).setShuffleDataDistribution(RssProtos.DataDistribution.valueOf(dataDistributionType.name())).setMaxConcurrencyPerPartitionToWrite(maxConcurrencyPerPartitionToWrite).addAllPartitionRanges(this.toShufflePartitionRanges(partitionRanges)).putAllProperties(properties);
        if (mergeContext != null) {
            reqBuilder.setMergeContext(mergeContext);
        }
        RssProtos.RemoteStorage.Builder rsBuilder = RssProtos.RemoteStorage.newBuilder();
        rsBuilder.setPath(remoteStorageInfo.getPath());
        Map<String, String> remoteStorageConf = remoteStorageInfo.getConfItems();
        if (!remoteStorageConf.isEmpty()) {
            RssProtos.RemoteStorageConfItem.Builder rsConfBuilder = RssProtos.RemoteStorageConfItem.newBuilder();
            for (Map.Entry<String, String> entry : remoteStorageConf.entrySet()) {
                rsConfBuilder.setKey(entry.getKey()).setValue(entry.getValue());
                rsBuilder.addRemoteStorageConf(rsConfBuilder.build());
            }
        }
        reqBuilder.setRemoteStorage(rsBuilder.build());
        return this.getBlockingStub().registerShuffle(reqBuilder.build());
    }

    private RssProtos.ShuffleCommitResponse doSendCommit(String appId, int shuffleId) {
        RssProtos.ShuffleCommitRequest request = RssProtos.ShuffleCommitRequest.newBuilder().setAppId(appId).setShuffleId(shuffleId).build();
        int retryNum = 0;
        while (retryNum <= this.maxRetryAttempts) {
            try {
                RssProtos.ShuffleCommitResponse response = this.getBlockingStub().commitShuffleTask(request);
                return response;
            }
            catch (Exception e) {
                LOG.warn("Send commit to host[" + this.host + "], port[" + this.port + "] failed, try again, retryNum[" + ++retryNum + "]", (Throwable)e);
            }
        }
        throw new RssException("Send commit to host[" + this.host + "], port[" + this.port + "] failed");
    }

    private RssProtos.AppHeartBeatResponse doSendHeartBeat(String appId, long timeout) {
        RssProtos.AppHeartBeatRequest request = RssProtos.AppHeartBeatRequest.newBuilder().setAppId(appId).build();
        return ((ShuffleServerGrpc.ShuffleServerBlockingStub)this.blockingStub.withDeadlineAfter(timeout, TimeUnit.MILLISECONDS)).appHeartbeat(request);
    }

    @VisibleForTesting
    public long requirePreAllocation(String appId, int requireSize, int retryMax, long retryIntervalMax) throws Exception {
        return this.requirePreAllocation(appId, 0, Collections.emptyList(), Collections.emptyList(), requireSize, retryMax, retryIntervalMax);
    }

    @VisibleForTesting
    public long requirePreAllocation(String appId, int shuffleId, List<Integer> partitionIds, List<Integer> partitionRequireSizes, int requireSize, int retryMax, long retryIntervalMax) {
        return (Long)this.requirePreAllocation(appId, shuffleId, partitionIds, partitionRequireSizes, requireSize, retryMax, retryIntervalMax, new AtomicReference<StatusCode>(StatusCode.INTERNAL_ERROR), null).getLeft();
    }

    public Pair<Long, List<Integer>> requirePreAllocation(String appId, int shuffleId, List<Integer> partitionIds, List<Integer> partitionRequireSizes, int requireSize, int retryMax, long retryIntervalMax, AtomicReference<StatusCode> failedStatusCodeRef, ShuffleServerPushCostTracker costTracker) {
        RssProtos.RequireBufferResponse rpcResponse;
        RssProtos.RequireBufferRequest rpcRequest = RssProtos.RequireBufferRequest.newBuilder().setShuffleId(shuffleId).addAllPartitionIds(partitionIds).addAllPartitionRequireSizes(partitionRequireSizes).setAppId(appId).setRequireSize(requireSize).build();
        long start = System.currentTimeMillis();
        int retry = 0;
        long result = -1L;
        List<Object> needSplitPartitionIds = Collections.emptyList();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requiring buffer for appId: {}, shuffleId: {}, partitionIds: {} with {} bytes from {}:{}", new Object[]{appId, shuffleId, OutputUtils.listToSegment(partitionIds, 10L), requireSize, this.host, this.port});
        }
        while (true) {
            try {
                rpcResponse = this.getBlockingStub().requireBuffer(rpcRequest);
            }
            catch (Exception e) {
                LOG.error("Exception happened when requiring pre-allocated buffer from {}:{}", new Object[]{this.host, this.port, e});
                return Pair.of((Object)result, needSplitPartitionIds);
            }
            if (rpcResponse.getStatus() != RssProtos.StatusCode.NO_BUFFER && rpcResponse.getStatus() != RssProtos.StatusCode.NO_BUFFER_FOR_HUGE_PARTITION) break;
            failedStatusCodeRef.set(StatusCode.fromCode(rpcResponse.getStatus().getNumber()));
            if (retry >= retryMax) {
                LOG.warn("ShuffleServer " + this.host + ":" + this.port + " is full and can't send shuffle data successfully due to " + rpcResponse.getStatus() + " after retry " + retryMax + " times, cost: {}(ms)", (Object)(System.currentTimeMillis() - start));
                return Pair.of((Object)result, needSplitPartitionIds);
            }
            try {
                ClientInfo clientInfo = this.getClientInfo();
                if (clientInfo != null && costTracker != null) {
                    costTracker.recordRequireBufferFailure(clientInfo.getShuffleServerInfo().getId());
                }
                LOG.info("Can't require buffer for appId: {}, shuffleId: {}, partitionIds: {} with {} bytes from {}:{} due to {}, sleep and try[{}] again", new Object[]{appId, shuffleId, OutputUtils.listToSegment(partitionIds, 10L), requireSize, this.host, this.port, rpcResponse.getStatus(), retry});
                long backoffTime = Math.min(retryIntervalMax, 2000L * (1L << Math.min(retry, 16)) + (long)this.random.nextInt(2000));
                Thread.sleep(backoffTime);
            }
            catch (Exception e) {
                LOG.warn("Exception happened when requiring pre-allocated buffer from {}:{}", new Object[]{this.host, this.port, e});
            }
            ++retry;
        }
        if (rpcResponse.getStatus() == RssProtos.StatusCode.SUCCESS) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Require preAllocated size of {} from {}:{}, cost: {}(ms)", new Object[]{requireSize, this.host, this.port, System.currentTimeMillis() - start});
            }
            result = rpcResponse.getRequireBufferId();
            needSplitPartitionIds = rpcResponse.getNeedSplitPartitionIdsList();
        } else if (NOT_RETRY_STATUS_CODES.contains((Object)StatusCode.fromCode(rpcResponse.getStatus().getNumber()))) {
            failedStatusCodeRef.set(StatusCode.fromCode(rpcResponse.getStatus().getNumber()));
            String msg = "Can't require " + requireSize + " bytes from " + this.host + ":" + this.port + ", statusCode=" + rpcResponse.getStatus() + ", errorMsg:" + rpcResponse.getRetMsg();
            throw new NotRetryException(msg);
        }
        return Pair.of((Object)result, needSplitPartitionIds);
    }

    private RssProtos.ShuffleUnregisterByAppIdResponse doUnregisterShuffleByAppId(String appId, int timeoutSec) {
        RssProtos.ShuffleUnregisterByAppIdRequest request = RssProtos.ShuffleUnregisterByAppIdRequest.newBuilder().setAppId(appId).build();
        return ((ShuffleServerGrpc.ShuffleServerBlockingStub)this.blockingStub.withDeadlineAfter(timeoutSec, TimeUnit.SECONDS)).unregisterShuffleByAppId(request);
    }

    @Override
    public RssUnregisterShuffleByAppIdResponse unregisterShuffleByAppId(RssUnregisterShuffleByAppIdRequest request) {
        RssUnregisterShuffleByAppIdResponse response;
        RssProtos.ShuffleUnregisterByAppIdResponse rpcResponse = this.doUnregisterShuffleByAppId(request.getAppId(), request.getTimeoutSec());
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssUnregisterShuffleByAppIdResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                String msg = String.format("Errors on unregistering app from %s:%s for appId[%s] and timeout[%ss], error: %s", this.host, this.port, request.getAppId(), request.getTimeoutSec(), rpcResponse.getRetMsg());
                LOG.error(msg);
                throw new RssException(msg);
            }
        }
        return response;
    }

    private RssProtos.ShuffleUnregisterResponse doUnregisterShuffle(String appId, int shuffleId, int timeoutSec) {
        RssProtos.ShuffleUnregisterRequest request = RssProtos.ShuffleUnregisterRequest.newBuilder().setAppId(appId).setShuffleId(shuffleId).build();
        return ((ShuffleServerGrpc.ShuffleServerBlockingStub)this.blockingStub.withDeadlineAfter(timeoutSec, TimeUnit.SECONDS)).unregisterShuffle(request);
    }

    @Override
    public RssUnregisterShuffleResponse unregisterShuffle(RssUnregisterShuffleRequest request) {
        RssUnregisterShuffleResponse response;
        RssProtos.ShuffleUnregisterResponse rpcResponse = this.doUnregisterShuffle(request.getAppId(), request.getShuffleId(), request.getTimeoutSec());
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssUnregisterShuffleResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                String msg = String.format("Errors on unregistering shuffle from %s:%s for appId[%s].shuffleId[%s] and timeout[%ss], error: %s", this.host, this.port, request.getAppId(), request.getShuffleId(), request.getTimeoutSec(), rpcResponse.getRetMsg());
                LOG.error(msg);
                throw new RssException(msg);
            }
        }
        return response;
    }

    @Override
    public RssRegisterShuffleResponse registerShuffle(RssRegisterShuffleRequest request) {
        RssRegisterShuffleResponse response;
        RssProtos.ShuffleRegisterResponse rpcResponse = this.doRegisterShuffle(request.getAppId(), request.getShuffleId(), request.getPartitionRanges(), request.getRemoteStorageInfo(), request.getUser(), request.getDataDistributionType(), request.getMaxConcurrencyPerPartitionToWrite(), request.getMergeContext(), request.getProperties());
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssRegisterShuffleResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                String msg = "Can't register shuffle to " + this.host + ":" + this.port + " for appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssException(msg);
            }
        }
        return response;
    }

    @Override
    public RssSendShuffleDataResponse sendShuffleData(RssSendShuffleDataRequest request) {
        String appId = request.getAppId();
        Map<Integer, Map<Integer, List<ShuffleBlockInfo>>> shuffleIdToBlocks = request.getShuffleIdToBlocks();
        int stageAttemptNumber = request.getStageAttemptNumber();
        ShuffleServerPushCostTracker costTracker = request.getCostTracker();
        boolean isSuccessful = true;
        AtomicReference<StatusCode> failedStatusCode = new AtomicReference<StatusCode>(StatusCode.INTERNAL_ERROR);
        HashSet<Integer> needSplitPartitionIds = Sets.newHashSet();
        for (Map.Entry<Integer, Map<Integer, List<ShuffleBlockInfo>>> stb : shuffleIdToBlocks.entrySet()) {
            ArrayList<RssProtos.ShuffleData> shuffleData = Lists.newArrayList();
            int size = 0;
            int blockNum = 0;
            int shuffleId = stb.getKey();
            ArrayList<Integer> partitionIds = new ArrayList<Integer>();
            ArrayList<Integer> partitionRequireSizes = new ArrayList<Integer>();
            for (Map.Entry<Integer, List<ShuffleBlockInfo>> ptb : stb.getValue().entrySet()) {
                ArrayList<RssProtos.ShuffleBlock> shuffleBlocks = Lists.newArrayList();
                int partitionRequireSize = 0;
                for (ShuffleBlockInfo sbi : ptb.getValue()) {
                    shuffleBlocks.add(RssProtos.ShuffleBlock.newBuilder().setBlockId(sbi.getBlockId()).setCrc(sbi.getCrc()).setLength(sbi.getLength()).setTaskAttemptId(sbi.getTaskAttemptId()).setUncompressLength(sbi.getUncompressLength()).setData(UnsafeByteOperations.unsafeWrap(sbi.getData().nioBuffer())).build());
                    partitionRequireSize += sbi.getSize();
                    ++blockNum;
                }
                size += partitionRequireSize;
                shuffleData.add(RssProtos.ShuffleData.newBuilder().setPartitionId(ptb.getKey()).addAllBlock(shuffleBlocks).build());
                partitionIds.add(ptb.getKey());
                partitionRequireSizes.add(partitionRequireSize);
            }
            int allocateSize = size;
            int finalBlockNum = blockNum;
            try {
                RetryUtils.retryWithCondition(() -> {
                    Pair<Long, List<Integer>> allocationResult = this.requirePreAllocation(appId, shuffleId, partitionIds, partitionRequireSizes, allocateSize, request.getRetryMax() / this.maxRetryAttempts, request.getRetryIntervalMax(), failedStatusCode, costTracker);
                    long requireId = (Long)allocationResult.getLeft();
                    needSplitPartitionIds.addAll((Collection)allocationResult.getRight());
                    if (requireId == -1L) {
                        ClientInfo clientInfo = this.getClientInfo();
                        if (clientInfo != null && costTracker != null) {
                            costTracker.recordRequireBufferFailure(clientInfo.getShuffleServerInfo().getId());
                        }
                        throw new RssException(String.format("requirePreAllocation failed! size[%s], host[%s], port[%s]", allocateSize, this.host, this.port));
                    }
                    long start = System.currentTimeMillis();
                    RssProtos.SendShuffleDataRequest rpcRequest = RssProtos.SendShuffleDataRequest.newBuilder().setAppId(appId).setShuffleId((Integer)stb.getKey()).setRequireBufferId(requireId).addAllShuffleData(shuffleData).setTimestamp(start).setStageAttemptNumber(stageAttemptNumber).build();
                    RssProtos.SendShuffleDataResponse response = this.getBlockingStub().sendShuffleData(rpcRequest);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Do sendShuffleData to {}:{} rpc cost:" + (System.currentTimeMillis() - start) + " ms for " + allocateSize + " bytes with " + finalBlockNum + " blocks", (Object)this.host, (Object)this.port);
                    }
                    if (response.getStatus() != RssProtos.StatusCode.SUCCESS) {
                        String msg = "Can't send shuffle data with " + finalBlockNum + " blocks to " + this.host + ":" + this.port + ", statusCode=" + response.getStatus() + ", errorMsg:" + response.getRetMsg();
                        failedStatusCode.set(StatusCode.fromCode(response.getStatus().getNumber()));
                        if (NOT_RETRY_STATUS_CODES.contains(failedStatusCode.get())) {
                            throw new NotRetryException(msg);
                        }
                        throw new RssException(msg);
                    }
                    return response;
                }, null, request.getRetryIntervalMax(), this.maxRetryAttempts, t -> !(t instanceof OutOfMemoryError) && !(t instanceof NotRetryException));
            }
            catch (Throwable throwable) {
                LOG.warn("Failed to send shuffle data due to ", throwable);
                isSuccessful = false;
                break;
            }
        }
        RssSendShuffleDataResponse response = isSuccessful ? new RssSendShuffleDataResponse(StatusCode.SUCCESS) : new RssSendShuffleDataResponse(failedStatusCode.get());
        response.setNeedSplitPartitionIds(needSplitPartitionIds);
        return response;
    }

    @Override
    public RssSendCommitResponse sendCommit(RssSendCommitRequest request) {
        RssProtos.ShuffleCommitResponse rpcResponse = this.doSendCommit(request.getAppId(), request.getShuffleId());
        if (rpcResponse.getStatus() != RssProtos.StatusCode.SUCCESS) {
            String msg = "Can't commit shuffle data to " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + "], errorMsg:" + rpcResponse.getRetMsg();
            LOG.error(msg);
            throw new RssException(msg);
        }
        RssSendCommitResponse response = new RssSendCommitResponse(StatusCode.SUCCESS);
        response.setCommitCount(rpcResponse.getCommitCount());
        return response;
    }

    @Override
    public RssAppHeartBeatResponse sendHeartBeat(RssAppHeartBeatRequest request) {
        RssProtos.AppHeartBeatResponse appHeartBeatResponse = this.doSendHeartBeat(request.getAppId(), request.getTimeoutMs());
        if (appHeartBeatResponse.getStatus() != RssProtos.StatusCode.SUCCESS) {
            String msg = "Can't send heartbeat to " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", timeout=" + request.getTimeoutMs() + "ms], errorMsg:" + appHeartBeatResponse.getRetMsg();
            LOG.error(msg);
            return new RssAppHeartBeatResponse(StatusCode.INTERNAL_ERROR);
        }
        return new RssAppHeartBeatResponse(StatusCode.SUCCESS);
    }

    @Override
    public RssFinishShuffleResponse finishShuffle(RssFinishShuffleRequest request) {
        RssProtos.FinishShuffleRequest rpcRequest = RssProtos.FinishShuffleRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).build();
        long start = System.currentTimeMillis();
        RssProtos.FinishShuffleResponse rpcResponse = this.getBlockingStub().finishShuffle(rpcRequest);
        if (rpcResponse.getStatus() != RssProtos.StatusCode.SUCCESS) {
            String msg = "Can't finish shuffle process to " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + "], errorMsg:" + rpcResponse.getRetMsg();
            LOG.error(msg);
            throw new RssException(msg);
        }
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "]";
        LOG.info("FinishShuffle to {}:{} for {} cost {} ms", new Object[]{this.host, this.port, requestInfo, System.currentTimeMillis() - start});
        RssFinishShuffleResponse response = new RssFinishShuffleResponse(StatusCode.SUCCESS);
        return response;
    }

    @Override
    public RssReportShuffleResultResponse reportShuffleResult(RssReportShuffleResultRequest request) {
        RssReportShuffleResultResponse response;
        ArrayList<RssProtos.PartitionToBlockIds> partitionToBlockIds = Lists.newArrayList();
        for (Map.Entry<Integer, List<Long>> entry : request.getPartitionToBlockIds().entrySet()) {
            List<Long> blockIds = entry.getValue();
            if (blockIds == null || blockIds.isEmpty()) continue;
            partitionToBlockIds.add(RssProtos.PartitionToBlockIds.newBuilder().setPartitionId(entry.getKey()).addAllBlockIds((Iterable<? extends Long>)entry.getValue()).build());
        }
        RssProtos.ReportShuffleResultRequest recRequest = RssProtos.ReportShuffleResultRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setTaskAttemptId(request.getTaskAttemptId()).setBitmapNum(request.getBitmapNum()).addAllPartitionToBlockIds(partitionToBlockIds).build();
        RssProtos.ReportShuffleResultResponse rpcResponse = this.doReportShuffleResult(recRequest);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssReportShuffleResultResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                String msg = "Can't report shuffle result to " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssException(msg);
            }
        }
        return response;
    }

    private RssProtos.ReportShuffleResultResponse doReportShuffleResult(RssProtos.ReportShuffleResultRequest rpcRequest) {
        try {
            return RetryUtils.retryWithCondition(() -> this.getBlockingStub().reportShuffleResult(rpcRequest), null, 0L, this.maxRetryAttempts, t -> {
                if (t instanceof StatusRuntimeException) {
                    return !(t.getCause() instanceof InterruptedException);
                }
                return t instanceof Exception;
            });
        }
        catch (Throwable t2) {
            throw new RssException("Failed to report shuffle result to host[" + this.host + "], port[" + this.port + "]", t2);
        }
    }

    @Override
    public RssGetShuffleResultResponse getShuffleResult(RssGetShuffleResultRequest request) {
        RssGetShuffleResultResponse response;
        RssProtos.GetShuffleResultRequest rpcRequest = RssProtos.GetShuffleResultRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).setBlockIdLayout(RssProtos.BlockIdLayout.newBuilder().setSequenceNoBits(request.getBlockIdLayout().sequenceNoBits).setPartitionIdBits(request.getBlockIdLayout().partitionIdBits).setTaskAttemptIdBits(request.getBlockIdLayout().taskAttemptIdBits).build()).build();
        RssProtos.GetShuffleResultResponse rpcResponse = this.getBlockingStub().getShuffleResult(rpcRequest);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                try {
                    response = new RssGetShuffleResultResponse(StatusCode.SUCCESS, rpcResponse.getSerializedBitmap().toByteArray());
                    break;
                }
                catch (Exception e) {
                    throw new RssException(e);
                }
            }
            default: {
                String msg = "Can't get shuffle result from " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public RssGetShuffleResultResponse getShuffleResultForMultiPart(RssGetShuffleResultForMultiPartRequest request) {
        RssGetShuffleResultResponse response;
        RssProtos.GetShuffleResultForMultiPartRequest rpcRequest = RssProtos.GetShuffleResultForMultiPartRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).addAllPartitions(request.getPartitions()).setBlockIdLayout(RssProtos.BlockIdLayout.newBuilder().setSequenceNoBits(request.getBlockIdLayout().sequenceNoBits).setPartitionIdBits(request.getBlockIdLayout().partitionIdBits).setTaskAttemptIdBits(request.getBlockIdLayout().taskAttemptIdBits).build()).build();
        RssProtos.GetShuffleResultForMultiPartResponse rpcResponse = this.getBlockingStub().getShuffleResultForMultiPart(rpcRequest);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                try {
                    response = new RssGetShuffleResultResponse(StatusCode.SUCCESS, rpcResponse.getSerializedBitmap().toByteArray());
                    break;
                }
                catch (Exception e) {
                    throw new RssException(e);
                }
            }
            default: {
                String msg = "Can't get shuffle result from " + this.host + ":" + this.port + " for [appId=" + request.getAppId() + ", shuffleId=" + request.getShuffleId() + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public RssGetShuffleDataResponse getShuffleData(RssGetShuffleDataRequest request) {
        RssGetShuffleDataResponse response;
        RssProtos.GetLocalShuffleDataResponse rpcResponse;
        long start = System.currentTimeMillis();
        RssProtos.GetLocalShuffleDataRequest rpcRequest = RssProtos.GetLocalShuffleDataRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).setPartitionNumPerRange(request.getPartitionNumPerRange()).setPartitionNum(request.getPartitionNum()).setOffset(request.getOffset()).setLength(request.getLength()).setTimestamp(start).setStorageId(request.getStorageId()).addAllNextReadSegments(request.getNextReadSegments().stream().map(x -> RssProtos.ReadSegment.newBuilder().setLength(x.getLength()).setOffset(x.getOffset()).build()).collect(Collectors.toList())).build();
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], partitionId[" + request.getPartitionId() + "], storageId[" + request.getStorageId() + "]";
        int retry = 0;
        while ((rpcResponse = this.getBlockingStub().getLocalShuffleData(rpcRequest)).getStatus() == RssProtos.StatusCode.NO_BUFFER) {
            this.waitOrThrow(request, retry, requestInfo, StatusCode.fromProto(rpcResponse.getStatus()), start);
            ++retry;
        }
        switch (rpcResponse.getStatus()) {
            case SUCCESS: {
                byte[] data = rpcResponse.getData().toByteArray();
                LOG.info("GetShuffleData from {}:{} for {} cost {} ms with {} bytes", new Object[]{this.host, this.port, requestInfo, System.currentTimeMillis() - start, data.length});
                response = new RssGetShuffleDataResponse(StatusCode.SUCCESS, ByteBuffer.wrap(data));
                break;
            }
            default: {
                String msg = "Can't get shuffle data from " + this.host + ":" + this.port + " for " + requestInfo + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public RssGetShuffleIndexResponse getShuffleIndex(RssGetShuffleIndexRequest request) {
        RssGetShuffleIndexResponse response;
        RssProtos.GetLocalShuffleIndexResponse rpcResponse;
        RssProtos.GetLocalShuffleIndexRequest rpcRequest = RssProtos.GetLocalShuffleIndexRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).setPartitionNumPerRange(request.getPartitionNumPerRange()).setPartitionNum(request.getPartitionNum()).build();
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], partitionId[" + request.getPartitionId() + "]";
        long start = System.currentTimeMillis();
        int retry = 0;
        while ((rpcResponse = this.getBlockingStub().getLocalShuffleIndex(rpcRequest)).getStatus() == RssProtos.StatusCode.NO_BUFFER) {
            this.waitOrThrow(request, retry, requestInfo, StatusCode.fromProto(rpcResponse.getStatus()), start);
            ++retry;
        }
        switch (rpcResponse.getStatus()) {
            case SUCCESS: {
                byte[] data = rpcResponse.getIndexData().toByteArray();
                LOG.info("GetShuffleIndex from {}:{} for {} cost {} ms with {} bytes", new Object[]{this.host, this.port, requestInfo, System.currentTimeMillis() - start, data.length});
                response = new RssGetShuffleIndexResponse(StatusCode.SUCCESS, new NettyManagedBuffer(Unpooled.wrappedBuffer(data)), rpcResponse.getDataFileLen(), rpcResponse.getStorageIdsList().stream().mapToInt(Integer::intValue).toArray());
                break;
            }
            default: {
                String msg = "Can't get shuffle index from " + this.host + ":" + this.port + " for " + requestInfo + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public RssGetInMemoryShuffleDataResponse getInMemoryShuffleData(RssGetInMemoryShuffleDataRequest request) {
        RssGetInMemoryShuffleDataResponse response;
        RssProtos.GetMemoryShuffleDataResponse rpcResponse;
        long start = System.currentTimeMillis();
        ByteString serializedTaskIdsBytes = ByteString.EMPTY;
        try {
            if (request.getExpectedTaskIds() != null) {
                serializedTaskIdsBytes = UnsafeByteOperations.unsafeWrap(RssUtils.serializeBitMap(request.getExpectedTaskIds()));
            }
        }
        catch (Exception e) {
            throw new RssException("Errors on serializing task ids bitmap.", e);
        }
        RssProtos.GetMemoryShuffleDataRequest rpcRequest = RssProtos.GetMemoryShuffleDataRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).setLastBlockId(request.getLastBlockId()).setReadBufferSize(request.getReadBufferSize()).setSerializedExpectedTaskIdsBitmap(serializedTaskIdsBytes).setTimestamp(start).build();
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], partitionId[" + request.getPartitionId() + "]";
        int retry = 0;
        while ((rpcResponse = this.getBlockingStub().getMemoryShuffleData(rpcRequest)).getStatus() == RssProtos.StatusCode.NO_BUFFER) {
            this.waitOrThrow(request, retry, requestInfo, StatusCode.fromProto(rpcResponse.getStatus()), start);
            ++retry;
        }
        switch (rpcResponse.getStatus()) {
            case SUCCESS: {
                byte[] data = rpcResponse.getData().toByteArray();
                LOG.info("GetInMemoryShuffleData from {}:{} for {} cost {} ms with {} bytes", new Object[]{this.host, this.port, requestInfo, System.currentTimeMillis() - start, data.length});
                response = new RssGetInMemoryShuffleDataResponse(StatusCode.SUCCESS, ByteBuffer.wrap(data), this.toBufferSegments(rpcResponse.getShuffleDataBlockSegmentsList()));
                break;
            }
            default: {
                String msg = "Can't get shuffle in memory data from " + this.host + ":" + this.port + " for " + requestInfo + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public RssStartSortMergeResponse startSortMerge(RssStartSortMergeRequest request) {
        RssStartSortMergeResponse response;
        ByteString serializedBlockIdsBytes = ByteString.EMPTY;
        try {
            if (request.getExpectedTaskIds() != null) {
                serializedBlockIdsBytes = UnsafeByteOperations.unsafeWrap(RssUtils.serializeBitMap(request.getExpectedTaskIds()));
            }
        }
        catch (Exception e) {
            throw new RssException("Errors on serializing task ids bitmap.", e);
        }
        RssProtos.StartSortMergeRequest rpcRequest = RssProtos.StartSortMergeRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).setUniqueBlocksBitmap(serializedBlockIdsBytes).build();
        long start = System.currentTimeMillis();
        RssProtos.StartSortMergeResponse rpcResponse = this.getBlockingStub().startSortMerge(rpcRequest);
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], partitionId[" + request.getPartitionId() + "]";
        LOG.info("startSortMerge to {}:{} for {} cost {} ms", new Object[]{this.host, this.port, requestInfo, System.currentTimeMillis() - start});
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssStartSortMergeResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                String msg = "Can't report unique block to from " + this.host + ":" + this.port + " for " + requestInfo + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssException(msg);
            }
        }
        return response;
    }

    @Override
    public RssGetSortedShuffleDataResponse getSortedShuffleData(RssGetSortedShuffleDataRequest request) {
        RssGetSortedShuffleDataResponse response;
        RssProtos.GetSortedShuffleDataResponse rpcResponse;
        long start = System.currentTimeMillis();
        RssProtos.GetSortedShuffleDataRequest rpcRequest = RssProtos.GetSortedShuffleDataRequest.newBuilder().setAppId(request.getAppId()).setShuffleId(request.getShuffleId()).setPartitionId(request.getPartitionId()).setMergedBlockId(request.getBlockId()).setTimestamp(start).build();
        String requestInfo = "appId[" + request.getAppId() + "], shuffleId[" + request.getShuffleId() + "], partitionId[" + request.getPartitionId() + "], blockId[" + request.getBlockId() + "]";
        int retry = 0;
        while ((rpcResponse = this.getBlockingStub().getSortedShuffleData(rpcRequest)).getStatus() == RssProtos.StatusCode.NO_BUFFER) {
            this.waitOrThrow(request, retry, requestInfo, StatusCode.fromProto(rpcResponse.getStatus()), start);
            ++retry;
        }
        LOG.info("GetSortedShuffleData from {}:{} for {} cost {} ms", new Object[]{this.host, this.port, requestInfo, System.currentTimeMillis() - start});
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssGetSortedShuffleDataResponse(StatusCode.SUCCESS, rpcResponse.getRetMsg(), rpcResponse.getData().asReadOnlyByteBuffer(), rpcResponse.getNextBlockId(), rpcResponse.getMState());
                break;
            }
            default: {
                String msg = "Can't get sorted shuffle data from " + this.host + ":" + this.port + " for " + requestInfo + ", errorMsg:" + rpcResponse.getRetMsg();
                LOG.error(msg);
                throw new RssFetchFailedException(msg);
            }
        }
        return response;
    }

    @Override
    public ClientInfo getClientInfo() {
        return new ClientInfo(ClientType.GRPC, this.serverInfo == null ? new ShuffleServerInfo(this.host, this.port) : this.serverInfo);
    }

    protected void waitOrThrow(RetryableRequest request, int retry, String requestInfo, StatusCode statusCode, long start) {
        if (retry >= request.getRetryMax()) {
            String msg = String.format("ShuffleServer %s:%s is full when %s due to %s, after %d retries, cost %d ms", new Object[]{this.host, this.port, request.operationType(), statusCode, request.getRetryMax(), System.currentTimeMillis() - start});
            LOG.error(msg);
            throw new RssFetchFailedException(msg);
        }
        try {
            long backoffTime = Math.min(request.getRetryIntervalMax(), 2000L * (1L << Math.min(retry, 16)) + (long)this.random.nextInt(2000));
            LOG.warn("Can't acquire buffer for {} from {}:{} when executing {}, due to {}. Will retry {} more time(s) after waiting {} milliseconds.", new Object[]{requestInfo, this.host, this.port, request.operationType(), statusCode, request.getRetryMax() - retry, backoffTime});
            Thread.sleep(backoffTime);
        }
        catch (InterruptedException e) {
            LOG.warn("Exception happened when executing {} from {}:{}", new Object[]{request.operationType(), this.host, this.port, e});
        }
    }

    private List<RssProtos.ShufflePartitionRange> toShufflePartitionRanges(List<PartitionRange> partitionRanges) {
        ArrayList<RssProtos.ShufflePartitionRange> ret = Lists.newArrayList();
        for (PartitionRange partitionRange : partitionRanges) {
            ret.add(RssProtos.ShufflePartitionRange.newBuilder().setStart(partitionRange.getStart()).setEnd(partitionRange.getEnd()).build());
        }
        return ret;
    }

    protected List<BufferSegment> toBufferSegments(List<RssProtos.ShuffleDataBlockSegment> blockSegments) {
        ArrayList<BufferSegment> ret = Lists.newArrayList();
        for (RssProtos.ShuffleDataBlockSegment sdbs : blockSegments) {
            ret.add(new BufferSegment(sdbs.getBlockId(), sdbs.getOffset(), sdbs.getLength(), sdbs.getUncompressLength(), sdbs.getCrc(), sdbs.getTaskAttemptId()));
        }
        return ret;
    }

    @VisibleForTesting
    public void adjustTimeout(long timeout) {
        this.rpcTimeout = timeout;
    }
}

