/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.nio.ByteBuffer;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.shaded.io.netty.buffer.Unpooled;
import org.apache.uniffle.shaded.io.netty.util.IllegalReferenceCountException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleIndexResult {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleIndexResult.class);
    private static final int[] DEFAULT_STORAGE_IDS = new int[]{0};
    private final ManagedBuffer buffer;
    private final int[] storageIds;
    private long dataFileLen;
    private String dataFileName;

    public ShuffleIndexResult() {
        this(ByteBuffer.wrap(new byte[0]), -1L);
    }

    public ShuffleIndexResult(byte[] data, long dataFileLen) {
        this(data != null ? ByteBuffer.wrap(data) : null, dataFileLen);
    }

    public ShuffleIndexResult(ByteBuffer data, long dataFileLen) {
        this((ManagedBuffer)new NettyManagedBuffer(data != null ? Unpooled.wrappedBuffer(data) : Unpooled.EMPTY_BUFFER), dataFileLen, null, DEFAULT_STORAGE_IDS);
    }

    public ShuffleIndexResult(ManagedBuffer buffer, long dataFileLen, String dataFileName) {
        this(buffer, dataFileLen, dataFileName, DEFAULT_STORAGE_IDS);
    }

    public ShuffleIndexResult(ManagedBuffer buffer, long dataFileLen, String dataFileName, int storageId) {
        this(buffer, dataFileLen, dataFileName, new int[]{storageId});
    }

    public ShuffleIndexResult(ManagedBuffer buffer, long dataFileLen, String dataFileName, int[] storageIds) {
        this.buffer = buffer;
        this.dataFileLen = dataFileLen;
        this.dataFileName = dataFileName;
        this.storageIds = storageIds;
    }

    public byte[] getData() {
        if (this.buffer == null) {
            return null;
        }
        if (this.buffer.nioByteBuffer().hasArray()) {
            return this.buffer.nioByteBuffer().array();
        }
        return ByteBufUtils.readBytes(this.buffer.byteBuf());
    }

    public ByteBuffer getIndexData() {
        return this.buffer.nioByteBuffer();
    }

    public long getDataFileLen() {
        return this.dataFileLen;
    }

    public boolean isEmpty() {
        return this.buffer == null || this.buffer.size() == 0;
    }

    public void release() {
        if (this.buffer != null) {
            try {
                this.buffer.release();
            }
            catch (IllegalReferenceCountException e) {
                LOG.warn("Failed to release shuffle index result with length {} of {}. Maybe it has been released by others.", new Object[]{this.dataFileLen, this.dataFileName, e});
            }
        }
    }

    public ManagedBuffer getManagedBuffer() {
        return this.buffer;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public int[] getStorageIds() {
        return this.storageIds;
    }
}

